/**
 * File:      nz32s_default_config.h
 *
 * Author:    Modtronix Engineering - www.modtronix.com
 *
 * Description:
 *
 * Software License Agreement:
 * This software has been written or modified by Modtronix Engineering. The code
 * may be modified and can be used free of charge for commercial and non commercial
 * applications. If this is modified software, any license conditions from original
 * software also apply. Any redistribution must include reference to 'Modtronix
 * Engineering' and web link(www.modtronix.com) in the file header.
 *
 * THIS SOFTWARE IS PROVIDED IN AN 'AS IS' CONDITION. NO WARRANTIES, WHETHER EXPRESS,
 * IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
 * COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 */
#ifndef MODTRONIX_NZ32S_NZ32S_DEFAULT_CONFIG_H_
#define MODTRONIX_NZ32S_NZ32S_DEFAULT_CONFIG_H_

//This file requires a file called "modtronix_config.h" to exist in the project!
//Use this file to override any of the default defines below. Do NOT edit this file!
#if !defined(NO_MODTRONIX_CONFIG)
    #include "modtronix_config.h"
#endif


// Copy from here to custom nz32s_defines.h file //////////////////////////////

//Set to 0 to disable A13 and A14 from being used(are SWD serial program/debug ping). Must be done if
//debugging is going to be used. These pins are used by ST-Link for programming debugging, but also used
//for battery level monitoring, and enabling fast battery charge. Setting this define to 0 will disable these
//functions, but will enable programming and debugging via SWD (ST-Link)
#if !defined(NZ32S_USE_A13_A14)
#define     NZ32S_USE_A13_A14    0
#endif

//Defines is Windowed or Independent Watchdog timer should be used. Windowed Watchdog Timer, is topped during
//low power mode, but Independent is NOT(will reset CPU). Use WWDG if CPU will go to low power mode
#if !defined(NZ32S_USE_WWDG)
#define     NZ32S_USE_WWDG    1
#endif


// End of contents to copy to custom nz32s_defines.h file /////////////////////

#endif /* MODTRONIX_NZ32S_NZ32S_DEFAULT_CONFIG_H_ */
