/**
 * File:      lcd2s.cpp
 * 
 * Author:    Modtronix Engineering - www.modtronix.com
 * 
 * Description:
 * 
 * Software License Agreement:
 * This software has been written or modified by Modtronix Engineering. The code
 * may be modified and can be used free of charge for commercial and non commercial
 * applications. If this is modified software, any license conditions from original
 * software also apply. Any redistribution must include reference to 'Modtronix
 * Engineering' and web link(www.modtronix.com) in the file header. 
 * 
 * THIS SOFTWARE IS PROVIDED IN AN 'AS IS' CONDITION. NO WARRANTIES, WHETHER EXPRESS,
 * IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
 * COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 */ 
#include "mbed.h"
#include "lcd2s.h"


// DEFINES ////////////////////////////////////////////////////////////////////


// GLOBAL VARIABLES ///////////////////////////////////////////////////////////
#if (LCD2S_USE_MALLOC == 0)
uint8_t buf[80];
uint32_t dirtyRows[4];
#endif

// Function Prototypes ////////////////////////////////////////////////////////


// DEBUG ////////////////////////////////////////////////////////////////////
//IMPORTANT, when enabling debugging, it is very important to note the following:
//- If (MX_DEBUG_IS_POINTER==1), ensure there is global Stream pointer defined somewhere in code to override "pMxDebug = NULL" below!
//- If (MX_DEBUG_IS_POINTER==0), define a mxDebug() function somewhere in code to handel debug output
#define DEBUG_ENABLE            1
#if (DEBUG_ENABLE==1) && !defined(NDEBUG)
//Alternative method in stead of using NULL below. This requires to create derived Stream class in each file we want to use debugging
//    class modtronixDebugStream : public Stream {int _putc(int value) {return 0;}int _getc() {return 0;}};
//    static modtronixDebugStream modtronixDebug;
//    WEAK Stream* pMxDebug = &modtronixDebug;
    #if (MX_DEBUG_IS_POINTER==1)        //More efficient, but only works if pMxDebug is defined in code. Disabled by default!
        WEAK Stream* pMxDebug = NULL;
        #define MX_DEBUG  pMxDebug->printf
    #else
        WEAK void mxDebug(const char *format, ...) {}
        #define MX_DEBUG mxDebug
    #endif
#else
    //GCC's CPP has extensions; it allows for macros with a variable number of arguments. We use this extension here to preprocess pmesg away.
    #define MX_DEBUG(format, args...) ((void)0)
#endif



LCD2S::LCD2S(uint8_t rows/* = 4*/, uint8_t columns/* = 20*/) {
    contrast = 200;
    brightness = 200;
    this->rows = rows;
    this->columns = columns;
    bufSize = rows * columns;
    cursor_row = cursor_col = 0;

    //MX_DEBUG("\r\nLCD2S()");

#if (LCD2S_USE_MALLOC == 1)
    buf = new uint8_t[bufSize)];
    dirtyRows = new uint32_t(rows);
#endif

    pBuf = buf;
    pDirtyRows = dirtyRows;
    memset(pBuf, ' ', sizeof(buf));
    memset(pDirtyRows, 0, 4 * rows);
}

void LCD2S::clearDisplay() {
    memset(pBuf, ' ', sizeof(buf));
    memset(pDirtyRows, 0xff, 4 * rows);
}

void LCD2S::setCursor(int8_t row, int8_t col) {
    cursor_row = row-1;
    if(cursor_row > rows)
        cursor_row = rows-1;

    cursor_col = col-1;
    if(cursor_col > columns)
        cursor_col = columns-1;
};

