/**
 * File:      lcd2s_i2c.h
 *
 * Author:    Modtronix Engineering - www.modtronix.com
 *
 * Description:
 *
 * Software License Agreement:
 * This software has been written or modified by Modtronix Engineering. The code
 * may be modified and can be used free of charge for commercial and non commercial
 * applications. If this is modified software, any license conditions from original
 * software also apply. Any redistribution must include reference to 'Modtronix
 * Engineering' and web link(www.modtronix.com) in the file header.
 *
 * THIS SOFTWARE IS PROVIDED IN AN 'AS IS' CONDITION. NO WARRANTIES, WHETHER EXPRESS,
 * IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
 * COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 */

#ifndef MODTRONIX_LCD2S_LCD2S_I2C_H_
#define MODTRONIX_LCD2S_LCD2S_I2C_H_

#include "mbed.h"
#include "lcd2s.h"

class LCD2S_I2C : public LCD2S {
public:
    LCD2S_I2C(I2C* i2cBus, uint8_t rows = 4, uint8_t columns = 20);

    /** Initializes the LCD2S device with default values
     * - Interrupt pin is Open Collector output type
     * - Backlight On
     * - Display On
     * - Backlight 200 (value from 0 to 255)
     * - Cursor off, block cursor off
     * - Cursor moves forward
     * - Keypad is 4x4 button type (if present)
     * - OUT1 disabled
     * - GPIO1 to 3 disabled
     * - Keypad Buzzer off
     * - Keypad repeat rate = 320ms
     * - Keypad Repeat Delay = 1 second
     * - Keypad Debounce Time = 64ms
     *
     * @param contrast The display contrast, a value from 0 to 255
     */
    void initDefault(uint8_t contrast);



    /** Causes the display to be updated with buffer content
     *
     * @return: 0 is successful, else non-0
     */
    uint8_t display();

    int writeChar(uint8_t c);

    /** Get current I2C address. Default address is 0x60
     */
    uint8_t getAdress() const {
        return i2cAdr;
    }

    /** Set current I2C address. Default address is 0x60
     */
    void setAdress(uint8_t adr) {
        this->i2cAdr = adr;
    }

//    void write(const char* str);

private:
    I2C* pI2C;
    uint8_t i2cAdr;
};

#endif /* MODTRONIX_LCD2S_LCD2S_I2C_H_ */
