/**
 * File:      lcd2s.h
 * 
 * Author:    Modtronix Engineering - www.modtronix.com
 * 
 * Description:
 * 
 * Software License Agreement:
 * This software has been written or modified by Modtronix Engineering. The code
 * may be modified and can be used free of charge for commercial and non commercial
 * applications. If this is modified software, any license conditions from original
 * software also apply. Any redistribution must include reference to 'Modtronix
 * Engineering' and web link(www.modtronix.com) in the file header. 
 * 
 * THIS SOFTWARE IS PROVIDED IN AN 'AS IS' CONDITION. NO WARRANTIES, WHETHER EXPRESS,
 * IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
 * COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 */ 

#ifndef MODTRONIX_LCD2S_LCD2S_H_
#define MODTRONIX_LCD2S_LCD2S_H_

#include "mbed.h"

#ifndef WEAK
    #if defined (__ICCARM__)
        #define WEAK     __weak
    #else
        #define WEAK     __attribute__((weak))
    #endif
#endif


//LCD2S Commands
/** Cursor moves backwards, no parameters */
#define LCD2S_CMD_CURSOR_MOVES_BACKWARDS    0x01

/** Cursor moves forward, no parameters */
#define LCD2S_CMD_CURSOR_MOVES_FORWARD      0x09

/** Blink Block cursor off, No parameters */
#define LCD2S_CMD_BLINK_BLOCK_CURSOR_OFF    0x10

/** Underline cursor on, No parameters */
#define LCD2S_CMD_UNDERLINE_CURSOR_ON       0x19

/** Display on, No parameters */
#define LCD2S_CMD_DISPLAY_ON                0x1A

/** Display off, No parameters */
#define LCD2S_CMD_DISPLAY_OFF               0x12

/** Configure interrupt pin as a push-pull output (not open collector), No parameters */
#define LCD2S_CMD_INTERRUPT_PIN_PUSH_PULL   0x22

/** Backlight on, No parameters */
#define LCD2S_CMD_BACKLIGHT_ON              0x28

/** Backlight off, No parameter */
#define LCD2S_CMD_BACKLIGHT_OFF             0x20

/** OUT1 off, No parameterss */
#define LCD2S_CMD_OUT1_OFF                  0x30

/** OUT2 off, No parameterss */
#define LCD2S_CMD_OUT2_OFF                  0x31

/** OUT1 on, No parameterss */
#define LCD2S_CMD_OUT1_ON                   0x38

/** OU21 on, No parameterss */
#define LCD2S_CMD_OUT2_ON                   0x39

/** GPIO1 off, No parameterss */
#define LCD2S_CMD_GPIO1_OFF                 0x40

/** GPIO2 off, No parameterss */
#define LCD2S_CMD_GPIO2_OFF                 0x41

/** GPIO1 on, No parameterss */
#define LCD2S_CMD_GPIO1_ON                  0x48

/** GPIO2 on, No parameterss */
#define LCD2S_CMD_GPIO2_ON                  0x49

/** Write string, string to follow */
#define LCD2S_CMD_WRITE_STRING              0x80

/** Set Backlight, byte to follow (0-255) */
#define LCD2S_CMD_SET_BACKLIGHT             0x81

/** Set contrast, byte to follow (0-254) */
#define LCD2S_CMD_SET_CONTRAST              0x82

/** Move cursor right, no parameters */
#define LCD2S_CMD_MOVE_CURSOR_RIGHT         0x83

/** Move cursor left, no parameters */
#define LCD2S_CMD_MOVE_CURSOR_LEFT          0x84

/** Shift display right, No parameters */
#define LCD2S_CMD_SHIFT_DISPLAY_RIGHT       0x85

/** Shift display left, No parameters */
#define LCD2S_CMD_SHIFT_DISPLAY_LEFT        0x86

/** Shift display up, No parameters */
#define LCD2S_CMD_SHIFT_DISPLAY_UP          0x85

/** Shift display down, No parameters */
#define LCD2S_CMD_SHIFT_DISPLAY_DOWN        0x86

/** Set cursor address, byte to follow (0-254) */
#define LCD2S_CMD_SET_CURSOR_ADDRESS        0x89

/** Set cursor address, next byte is row (1-n), next byte is column (1-n) */
#define LCD2S_CMD_SET_CURSOR_POSITION       0x8A

/** Clear Display, No parameters */
#define LCD2S_CMD_CLEAR_DISPLAY             0x8C

/** Remember next command, No parameters */
#define LCD2S_CMD_REMEMBER                  0x8D

/** Set I2C base address, next byte is character set code (0=vert bar graph, 1=nrw v.bar graph, 2=larg num) */
#define LCD2S_CMD_LOAD_CUSTOM_CHAR_SET      0x8E

/** Write large number string, string to follow with numbers (0 1 2 3 4 5 6 7 8 9 . : space) */
#define LCD2S_CMD_WRITE_LARGE_NUM_STING     0x8F

/** Set startup screen for a single line. Next byte is line number (1-4), followed by string (message for that line */
#define LCD2S_CMD_SET_STARTUP_SCREEN        0x90

/** Set I2C base address, next byte is address */
#define LCD2S_CMD_SET_I2C_BASE_ADR          0x91

/** Set I2C base address, next byte is adr (0-7), next 8 bytes are pixels */
#define LCD2S_CMD_DEFINE_CUSTOM_CHAR        0x92

/** Draw vert. bar graph, next byte is row (1-n), next byte is column (1-n), next byte is height (0-8) */
#define LCD2S_CMD_DRAW_VERT_BAR_GRAPH       0x93

/** Draw tall vert. bar graph (span 2 rows), next byte is row (1-n), next byte is column (1-n), next byte is height (0-8) */
#define LCD2S_CMD_DRAW_TALL_VERT_BAR_GRAPH  0x94

/** Configure device, followed by 4 bytes */
#define LCD2S_CMD_CONFIG_DEVICE             0x95

/** Set keypad repeat delay, byte to follow is 16ms multiples time (1-100 = 16-1600ms) */
#define LCD2S_CMD_SET_KEYPAD_REPEAT_DELAY   0xA0

/** Set keypad repeat rate, byte to follow is 16ms multiples time (1-100 = 16-1600ms) */
#define LCD2S_CMD_SET_KEYPAD_REPEAT_RATE    0xA1

/** Set keypad buzzer period, byte to follow is 16ms multiples time (1-100 = 16-1600ms) */
#define LCD2S_CMD_SET_KEYPAD_BUZZER_PERIOD  0xA2

/** Set maximum brightness, byte to follow (1-255) */
#define LCD2S_CMD_MAX_BACKLIGHT             0xA3

/** Get status. Next byte read is status. Bit 7 indicates if keypad buffer contains data (keys). Bits 0-6 = receive buffer space available. */
#define LCD2S_CMD_GET_STATUS                0xD0

/** Read next key from buffer. Next byte read is key */
#define LCD2S_CMD_GET_KEY                   0xD1

/** Read GPIO1, GPIO2 and GPIO3. Next byte read is values in bits 0 - 2 */
#define LCD2S_CMD_GET_GPIO1_TO_GPIO3        0xD3

/** Configure keypad and IO, byte to follow */
#define LCD2S_CMD_CONFIG_KEYPAD_AND_IO      0xE0

/** Set keypad debounce time, byte to follow is 8ms multiples time (1-15 = 8-120ms) */
#define LCD2S_CMD_SET_KEYPAD_DEBOUNCE_TIME  0xE1

/** Set OUT1 and OUT2, byte to follow is value (bit 0=OUT1, bit 1=OUT2) */
#define LCD2S_CMD_SET_OUT1_AND_OUT2         0xE2

/** Configure GPIO1, byte to follow */
#define LCD2S_CMD_CONFIG_GPIO1              0xE3

/** Configure GPIO1, byte to follow */
#define LCD2S_CMD_CONFIG_GPIO2              0xE4


class LCD2S : public Stream {
public:
    LCD2S(uint8_t rows = 4, uint8_t columns = 20);

    // Stream implementation - provides printf() interface
    // You would otherwise be forced to use writeChar()
    virtual int _putc(int value) { return writeChar(value); };
    virtual int _getc() { return -1; };

    /** Initializes the LCD2S device with default values
     * - Interrupt pin is Open Collector output type
     * - Backlight On
     * - Display On
     * - Backlight 200 (value from 0 to 255)
     * - Cursor off, block cursor off
     * - Cursor moves forward
     * - Keypad is 4x4 button type (if present)
     * - OUT1 disabled
     * - GPIO1 to 3 disabled
     * - Keypad Buzzer off
     * - Keypad repeat rate = 320ms
     * - Keypad Repeat Delay = 1 second
     * - Keypad Debounce Time = 64ms
     *
     * @param contrast The display contrast, a value from 0 to 255
     */
    virtual void initDefault(uint8_t contrast) = 0;

    /** Causes the display to be updated with buffer content
     *
     * @return 0 if success, else error code
     */
    virtual uint8_t display() = 0;

    void clearDisplay();

    /** Set the text cursor location, based on the size of the text
     *
     * @param row A value from 1-n
     * @param col A value from 1-n
     */
    void setCursor(int8_t row, int8_t col);

    virtual int writeChar(uint8_t c) = 0;

//    virtual void write(const char* str) = 0;

protected:
    uint8_t* pBuf;           //Display buffer
    uint16_t bufSize;       //Sixe of display buffer, is rows * columns by default
    uint8_t rows;           //Number of rows that this display has
    uint8_t columns;        //Number of columns that this display has
    uint8_t cursor_row;     //Current row, a value from 0 to (rows-1)
    uint8_t cursor_col;     //Current column, a value from 0 to (columns-1)
    uint8_t brightness;
    uint8_t contrast;

    uint32_t* pDirtyRows;    //Each bit indicates if any characters are dirty in row
};



#endif /* MODTRONIX_LCD2S_LCD2S_H_ */
