/**
 * File:      dins-r8.h
 *
 * Author:    Modtronix Engineering - www.modtronix.com
 *
 * Description:
 *
 * Software License Agreement:
 * This software has been written or modified by Modtronix Engineering. The code
 * may be modified and can be used free of charge for commercial and non commercial
 * applications. If this is modified software, any license conditions from original
 * software also apply. Any redistribution must include reference to 'Modtronix
 * Engineering' and web link(www.modtronix.com) in the file header.
 *
 * THIS SOFTWARE IS PROVIDED IN AN 'AS IS' CONDITION. NO WARRANTIES, WHETHER EXPRESS,
 * IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
 * COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 */

#ifndef MODTRONIX_DINS_R8_I2C_H_
#define MODTRONIX_DINS_R8_I2C_H_

#include "mbed.h"


//Error Numbers
#define  DINS_R8_SUCCESS            0       //Success
#define  DINS_R8_ERR_I2C            0xff    //I2C Error
#define  DINS_R8_ERR_INVALID_RELAY  0xfe    //Invalid Relay number

class DINS_R8_I2C  {
public:
    DINS_R8_I2C(I2C* i2cBus);

    /** Writes given relay with given value
     *
     * @param relayNumber Relay to update, number from 1 to 8
     *
     * @param value New value, 0 if off, 1 is on
     *
     * @returns 0 if success, else error code
     */
    uint8_t writeRelay(int8_t relayNumber, bool value);

    /** Set all relays with new values. Each bit is 1 relay
     *
     * @param relays New values for relays, each bit is 1 relay
     *
     * @return 0 if success, else error code
     */
    uint8_t writeAllRelays(int8_t relays);

    /** Get current I2C address. Default address is 0x60
     */
    uint8_t getAddress() const {
        return i2cAdr;
    }

    /** Set current I2C address. Default address is 0x60
     */
    void setAddress(uint8_t i2cAdr) {
        this->i2cAdr = i2cAdr;
    }

    /** Get value of all relays. Each bit is 1 relay
     */
    uint8_t getRelays() const {
        return relays;
    }


protected:
    uint8_t relays;         //Value of all relays
    I2C* pI2C;
    uint8_t i2cAdr;
};



#endif /* MODTRONIX_DINS_R8_I2C_H_ */
