#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"

#define WS2812_BUF 3
#define NUM_COLORS 6
#define NUM_LEDS_PER_COLOR 1

PixelArray px(WS2812_BUF);

// See the program page for information on the timing numbers
// The given numbers are for the K64F
WS2812 ws(D6, WS2812_BUF, 0, 5, 5, 0);

int main()
{
    px.Set(0, 0);
    px.Set(1, 0x00ff00);
    px.Set(2, 0x00ee00);

    // Now the buffer is written, rotate it
    // by writing it out with an increasing offset
    while (1) {
            ws.write(px.getBuf());
            wait(0.075);
    }

}
