#include "mbed.h"
#include "EthernetInterface.h"
#include "ConnectorEndpoint.h"
#include "OptionsBuilder.h"

#include "Servo.h"

#include "StaticResource.h"
#include "ServoResource.h"

    /* Terminal connection */
RawSerial term(USBTX, USBRX);
Logger logger(&term);

/* Sensors */
#define SERVO_PIN D4
Servo servoA(SERVO_PIN);

/* Resources */
StaticResource mfg(&logger, "3/0/0", "Freescale");
StaticResource model(&logger, "3/0/1", "K64F mbed Ethernet demo");

StaticResource latitude(&logger, "6/0/0", "35.296");
StaticResource longitude(&logger, "6/0/1", "-120.677");

ServoResource servoR(&logger, "3302/0/5600", &servoA, true);

/* invoked through linker magic via Endpoint::start() */
Connector::Options *configure_endpoint(Connector::OptionsBuilder &config)
{
    /* NSP configuration is in nsp_configuration.h */
    logger.log("configure_endpoint: building endpoint configuration...");
    servoR.setMaxAge(15);
    return config.addResource(&mfg)
                 .addResource(&model)
                 .addResource(&latitude)
                 .addResource(&longitude)
                 .addResource(&servoR)
                 .build();
}

int main() {
   logger.log("\r\n\r\nServoTest booting\r\n");
   Connector::Endpoint::plumbNetwork();
   Connector::Endpoint::start();
}
