#ifndef SERVO_RESOURCE_H
#define SERVO_RESOURCE_H

#include "DynamicResource.h"
#include "Servo.h"

class ServoResource : public DynamicResource {
public:
    ServoResource(const Logger *logger, const char *name, Servo *servo, const bool observable = false)
     : DynamicResource(logger, name, "ServoResource", SN_GRS_PUT_ALLOWED, observable), servo(servo)
    {}
    
    void on();
    void off();
    
    virtual void put(const string);
    virtual string get();
    
private:
    Servo *servo;
};

#endif