

#include "mbed.h"
#include "MCP23S17.h"
#include "TextLCD.h"

SPI spi(p5, p6, p7);
I2C i2c(p9, p10);
DigitalOut cs(p21);




void relay_porta(int bitoutput)
{

    cs=1;

    cs=0;
    wait_us(1);
    spi.write(0x42);
    spi.write(0x12);
    spi.write(bitoutput);
    cs=1;
}

void relay_portb(int bitoutput)
{

    cs=1;

    cs=0;
    wait_us(1);
    spi.write(0x42);
    spi.write(0x13);
    spi.write(bitoutput);
    cs=1;
}

void mosfet_porta(int bitoutput)
{

    cs=1;

    cs=0;
    wait_us(1);
    spi.write(0x40);
    spi.write(0x12);
    spi.write(bitoutput);
    cs=1;
}

void mosfet_portb(int bitoutput)
{
    cs=1;

    cs=0;
    wait_us(1);
    spi.write(0x40);
    spi.write(0x13);
    spi.write(bitoutput);
    cs=1;
}

void autotest()
{
    relay_porta(0x00);
    wait_ms(100);
    for(int bitoutput=0x01; bitoutput <= 0x80; bitoutput= bitoutput*2) {
    relay_porta(bitoutput);
    wait_ms(100);
    }
}

int main()
{

    cs=1;
    spi.format(8,0);

    cs=0;
    wait_us(1);
    spi.write(0x42);        //write to address 001
    spi.write(0x0A);        //iocon bank 0
    spi.write(0x2A);        // setup af control register (BANK = 0, MIRROR = 0, SEQOP = 1, DISSLW = 0, HAEN = 1, ODR = 0, INTPOL = 1, NC = 0)
    cs=1;



    cs=0;                  //chipselect enable
    wait_us(1);
    spi.write(0x42);        //write to address 001
    spi.write(0x00);        //set direction I/O portA
    spi.write(0x00);        //all ports are outputs
    cs=1;

    cs=0;                  //chipselect enable
    wait_us(1);
    spi.write(0x42);        //write to address 001
    spi.write(0x01);        //set direction I/O portB
    spi.write(0x00);        //all ports are outputs
    cs=1;

    cs=0;
    wait_us(1);
    spi.write(0x42);
    spi.write(0x0C);        //GPPUA
    spi.write(0x00);        //pullup resistors disabled on all bits
    cs=1;

    cs=0;
    wait_us(1);
    spi.write(0x42);
    spi.write(0x0D);        //GPPUB
    spi.write(0x00);        //pullup resistors disabled on all bits
    cs=1;


    while(1) {
        autotest();

    }

}




