

#include "SwFilter.h"
#include "mbed.h"
 
 /*
  * Constructor
  */
 SwFilter::SwFilter(PinName in) 
     : _in(in) {    
         
     // reset all the flags and counters    
//     _samples = 0;
//     _output = 0;
//     _output_last = 0;
     _rising_flag = 0;
     _falling_flag = 0;
     _filter1 = 0;
     _filter2 = 0;
     _filter_sw = 0;
     
     // Attach ticker
     _ticker.attach(this, &SwFilter::_chatfilter, 0.01);     
 }
   
// void Pswitch::_sample() {
//    _output_last = _output;
//    _output = _in;
//    if (!_output && _output_last)
//    {
//        _rising_flag++;
//    }
//}

// return switch status after filter
 void SwFilter::_chatfilter() {
    _filter2 = _filter1;
    _filter1 = _in;    
    if ((_filter1==_in) & (_filter2==_filter1))
    {
        _filter_sw = _filter2;
    }
    if (_filter1 && !_filter2)
    {
        _rising_flag++;
    }
    if (!_filter1 && _filter2)
    {
        _falling_flag++;
    }
 } 
 
 int SwFilter::filter(void) {
     int buf = _filter_sw;
     return(buf);
 }
 
 // return number of rising edges
 int SwFilter::rise(void) {
     int return_value = _rising_flag; 
     _rising_flag = 0;
     return(return_value);
 }
 
 // return number of falling edges
 int SwFilter::fall(void) {
     int return_value = _falling_flag; 
     _falling_flag = 0;
     return(return_value);
 }
 
 
 // return the debounced status
 int SwFilter::read(void) {
     return(_in);
 }
 
 // shorthand for read()
 SwFilter::operator int() {
     return read();
 }
