#include "mbed.h"
#include "DigitDisplay.h"
#define Address 0xD0 
class Clock{
    public:
        Clock(PinName,PinName);
        void set(int sec , int min , int hour , int day , int date , int month , int year);
        void settime2bcd(int sec , int min , int hour , int day , int date , int month , int year);
        void get(int *second , int *minute , int *hours, int *day , int *date , int *month , int *year);
        void displays();
        void getAlarm(int *alarmsec , int *alarmmin  , int *alarmhours);
    private:  
        I2C i2c;
        DigitDisplay display;
        bool col;
};

Clock::Clock(PinName sda,PinName scl):i2c(sda,scl),display(PC_8, PC_6){
    col=1;
    display.clear();
}

void Clock::set(int sec , int min , int hour , int day , int date , int month , int year){
    char cmd[8];
    cmd[0] = 0x00;
    cmd[1] = sec;
    cmd[2] = min;
    cmd[3] = hour;
    cmd[4] = day;
    cmd[5] = date;
    cmd[6] = month;
    cmd[7] = year;
    i2c.write(Address, cmd, 8);
}

void Clock::settime2bcd(int sec , int min , int hour , int day , int date , int month , int year){
    int HBit = 0;
    int LBit = 0;
    int Sbcd = 0,Mbcd = 0,Hbcd = 0,DYbcd = 0,DTbcd = 0,MObcd = 0,Ybcd = 0;
    
    HBit = sec / 10;
    LBit = sec % 10;
    Sbcd = (HBit * 16) + LBit;
    
    HBit = min / 10;
    LBit = min % 10;
    Mbcd = (HBit * 16) + LBit;
    
    HBit = hour / 10;
    LBit = hour % 10;
    Hbcd = (HBit * 16) + LBit;
    
    HBit = day / 10;
    LBit = day % 10;
    DYbcd = (HBit * 16) + LBit;
    
    HBit = date / 10;
    LBit = date % 10;
    DTbcd = (HBit * 16) + LBit;
    
    HBit = month / 10;
    LBit = month % 10;
    MObcd = (HBit * 16) + LBit;
    
    
    HBit = year / 10;
    LBit = year % 10;
    Ybcd = (HBit * 16) + LBit;
    
    set(Sbcd,Mbcd,Hbcd,DYbcd,DTbcd,MObcd,Ybcd);
}

void Clock::get(int *second , int *minute , int *hours, int *day , int *date , int *month , int *year){
    int HBit = 0;
    int LBit = 0;
    char cmd = 0;
    char Reads[7];
    
    for(int i=0;i<=7;i++){
        i2c.write(Address, &cmd, 1);
        i2c.read(Address, &Reads[i], 1);
        cmd++;
    }
    
    HBit = Reads[0] / 16;
    LBit = Reads[0] - (HBit * 16);
    *second = (HBit * 10) + LBit;
    
    HBit = Reads[1] / 16;
    LBit = Reads[1] - (HBit * 16);
    *minute = (HBit * 10) + LBit;
    
    HBit = Reads[2] / 16;
    LBit = Reads[2] - (HBit * 16);
    *hours = (HBit * 10) + LBit;
    
    HBit = Reads[0] / 16;
    LBit = Reads[0] - (HBit * 16);
    *day = (HBit * 10) + LBit;
    
    HBit = Reads[1] / 16;
    LBit = Reads[1] - (HBit * 16);
    *date = (HBit * 10) + LBit;
    
    HBit = Reads[2] / 16;
    LBit = Reads[2] - (HBit * 16);
    *month = (HBit * 10) + LBit;
    
    HBit = Reads[0] / 16;
    LBit = Reads[0] - (HBit * 16);
    *year = (HBit * 10) + LBit;
}

void Clock::displays(){
    int second,minute,hours,day,date,month,year;
    if(col){display.setColon(1);col=0;}
    else {display.setColon(0);col=1;}
    get(&second , &minute , &hours, &day , &date , &month , &year);
    display.write(0, hours / 10);
    display.write(1, hours % 10);
    display.write(2, minute / 10);
    display.write(3, minute % 10);
}

void Clock::getAlarm(int *alarmsec , int *alarmmin  , int *alarmhours){
    int HBit = 0;
    int LBit = 0;
    char cmd = 0;
    char ReadAlarm[4];
    
    for(int j=0;j<=4;j++){
        i2c.write(Address, &cmd, 1);
        i2c.read(Address, &ReadAlarm[j], 1);
        cmd++;
    }
    
    HBit = ReadAlarm[0] / 16;
    LBit = ReadAlarm[0] - (HBit * 16);
    *alarmsec = (HBit * 10) + LBit;
    
    HBit = ReadAlarm[1] / 16;
    LBit = ReadAlarm[1] - (HBit * 16);
    *alarmmin = (HBit * 10) + LBit;
    
    HBit = ReadAlarm[2] / 16;
    LBit = ReadAlarm[2] - (HBit * 16);
    *alarmhours = (HBit * 10) + LBit;
}