
// MBED I/O Server FOR PC Based Control
// 2011/2/7


#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"

DigitalOut led4(LED4, "led4");

// Declaring Digital outputs Pins
DigitalOut do1(p30); 
DigitalOut do2(p29);
DigitalOut do3(p28);
DigitalOut do4(p27);
DigitalOut do5(p26);
DigitalOut do6(p25);
DigitalOut do7(p24);
DigitalOut do8(p23);
DigitalOut do9(p22);
DigitalOut do10(p21);
// Declaring Digital Inptus Pins
DigitalIn di1(p5);
DigitalIn di2(p6);
DigitalIn di3(p7);
DigitalIn di4(p8);
DigitalIn di5(p9);
DigitalIn di6(p10);
DigitalIn di7(p11);
DigitalIn di8(p12);
DigitalIn di9(p13);
DigitalIn di10(p14);
DigitalIn di11(p15);
DigitalIn di12(p16);
DigitalIn di13(p17);
DigitalIn di14(p18);
DigitalIn di15(p19);
DigitalIn di16(p20);

char x[10],y[16];

// EthernetNetIf eth;
EthernetNetIf eth(
  IpAddr(192,168,1,25), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,1,1), //Gateway
  IpAddr(192,168,1,1)  //DNS
);

#define TCP_LISTENING_PORT 12345

TCPSocket ListeningSock;
TCPSocket* pConnectedSock; // for ConnectedSock
Host client;
TCPSocketErr err;

void onConnectedTCPSocketEvent(TCPSocketEvent e)
{
   switch(e)
    {
    case TCPSOCKET_CONNECTED:
        printf("TCP Socket Connected\r\n");
        break;
    case TCPSOCKET_WRITEABLE:
      //Can now write some data...
        printf("TCP Socket Writable\r\n");
        break;
    case TCPSOCKET_READABLE:
      //Can now read dome data...
        printf("TCP Socket Readable\r\n");
       // Read in any available data into the buffer
      
       //Parsing for the messege from I/O Server
       //1)Updating thr output status
       while ( pConnectedSock->recv(x, 10) ) {
       if(x[0]==0)
       {
             do1=0;
       }
       if(x[0]==1)
       {
        
        do1=1;
       }
       if(x[1]==0)
       {
        
        do2=0;
       }
       if(x[1]==1)
       {
        
        do2=1;
       }
       if(x[2]==0)
       {
        
        do3=0;
       }
       if(x[2]==1)
       {
        
        do3=1;
       }
       if(x[3]==0)
       {
       do4=0;
       }
       if(x[3]==1)
       {
       do4=1;
       }
       if(x[4]==0)
       {
       do5=0;
       }
       if(x[4]==1)
       {
       do5=1;
       }
       if(x[5]==0)
       {
       do6=0;
       }
       if(x[5]==1)
       {
       do6=1;
       }
       if(x[6]==0)
       {
       do7=0;
       }
       if(x[6]==1)
       {
       do7=1;
       }
       if(x[7]==0)
       {
       do8=0;
       }
       if(x[7]==1)
       {
       do8=1;
       }
       if(x[8]==0)
       {
       do9=0;
       }
       if(x[8]==1)
       {
       do9=1;
       }
       if(x[9]==0)
       {
       do10=0;
       }
       if(x[9]==1)
       {
       do10=1;
       }
       
      
      
// 2) send the inputs status to I/O Server
if (di1==1)
{
y[0]=1;
}
if (di1==0)
{
y[0]=0;
}
if (di2==1)
{
y[1]=1;
}
if (di2==0)
{
y[1]=0;
}
if (di3==1)
{
y[2]=1;
}
if (di3==0)
{
y[2]=0;
}
if (di4==1)
{
y[3]=1;
}
if (di4==0)
{
y[3]=0;
}
if (di1==5)
{
y[4]=1;
}
if (di5==0)
{
y[4]=0;
}
if (di6==1)
{
y[5]=1;
}
if (di6==0)
{
y[5]=0;
}
if (di7==1)
{
y[6]=1;
}
if (di7==0)
{
y[6]=0;
}
if (di8==1)
{
y[7]=1;
}
if (di8==0)
{
y[7]=0;
}
if (di9==1)
{
y[8]=1;
}
if (di9==0)
{
y[8]=0;
}
if (di10==1)
{
y[9]=1;
}
if (di10==0)
{
y[9]=0;
}
if (di11==1)
{
y[10]=1;
}
if (di11==0)
{
y[10]=0;
}
if (di12==1)
{
y[11]=1;
}
if (di12==0)
{
y[11]=0;
}
if (di13==1)
{
y[12]=1;
}
if (di13==0)
{
y[12]=0;
}
if (di14==1)
{
y[13]=1;
}
if (di14==0)
{
y[13]=0;
}
if (di15==1)
{
y[14]=1;
}
if (di15==0)
{
y[14]=0;
}
if (di16==1)
{
y[15]=1;
}
if (di16==0)
{
y[15]=0;
}
     
          
           pConnectedSock->send(y, 16);
            // make terminater
         
       }
       break;
    case TCPSOCKET_CONTIMEOUT:
        printf("TCP Socket Timeout\r\n");
        break;
    case TCPSOCKET_CONRST:
        printf("TCP Socket CONRST\r\n");
        break;
    case TCPSOCKET_CONABRT:
        printf("TCP Socket CONABRT\r\n");
        break;
    case TCPSOCKET_ERROR:
        printf("TCP Socket Error\r\n");
        break;
    case TCPSOCKET_DISCONNECTED:
    //Close socket...
        printf("TCP Socket Disconnected\r\n");        
        pConnectedSock->close();
        break;
    default:
        printf("DEFAULT\r\n"); 
      }
}


void onListeningTCPSocketEvent(TCPSocketEvent e)
{
    switch(e)
    {
    case TCPSOCKET_ACCEPT:
        printf("Listening: TCP Socket Accepted\r\n");
        // Accepts connection from client and gets connected socket.   
        err=ListeningSock.accept(&client, &pConnectedSock);
        if (err) {
            printf("onListeningTcpSocketEvent : Could not accept connection.\r\n");
            return; //Error in accept, discard connection
        }
        // Setup the new socket events
        pConnectedSock->setOnEvent(&onConnectedTCPSocketEvent);
        // We can find out from where the connection is coming by looking at the
        // Host parameter of the accept() method
        IpAddr clientIp = client.getIp();
        printf("Listening: Incoming TCP connection from %d.%d.%d.%d\r\n", 
           clientIp[0], clientIp[1], clientIp[2], clientIp[3]);
       break;
    // the following cases will not happen
    case TCPSOCKET_CONNECTED:
        printf("Listening: TCP Socket Connected\r\n");
        break;
    case TCPSOCKET_WRITEABLE:
        printf("Listening: TCP Socket Writable\r\n");
        break;
    case TCPSOCKET_READABLE:
        printf("Listening: TCP Socket Readable\r\n");
        break;
    case TCPSOCKET_CONTIMEOUT:
        printf("Listening: TCP Socket Timeout\r\n");
        break;
    case TCPSOCKET_CONRST:
        printf("Listening: TCP Socket CONRST\r\n");
        break;
    case TCPSOCKET_CONABRT:
        printf("Listening: TCP Socket CONABRT\r\n");
        break;
    case TCPSOCKET_ERROR:
        printf("Listening: TCP Socket Error\r\n");
        break;
    case TCPSOCKET_DISCONNECTED:
    //Close socket...
        printf("Listening: TCP Socket Disconnected\r\n");        
        ListeningSock.close();
        break;
    default:
        printf("DEFAULT\r\n"); 
     };
}


int main() {
  printf("\r\n");
  printf("Setting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\r\n", ethErr);
    return -1;
  }
  printf("Setup OK\r\n");

  IpAddr ip = eth.getIp();
  printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);

  
  // Set the callbacks for Listening
  ListeningSock.setOnEvent(&onListeningTCPSocketEvent); 
  
  // bind and listen on TCP
  err=ListeningSock.bind(Host(IpAddr(), TCP_LISTENING_PORT));
  printf("Binding..\r\n");
  if(err)
  {
   //Deal with that error...
    printf("Binding Error\n");
  }
   err=ListeningSock.listen(); // Starts listening
   printf("Listening...\r\n");
   if(err)
   {
    printf("Listening Error\r\n");
   }
 
  Timer tmr;
  tmr.start();

  while(true)
  {
    Net::poll();
    if(tmr.read() > 0.2) // sec
    {
      led4=!led4; //Show that we are alive
      tmr.reset();
    }
  }  
}
