
#include "mbed.h"
#include "PID.h"
#include "time.h"
#define RATE 0.01

// PID Tuning Parameters

AnalogIn kp_pin(p15);
AnalogIn ti_pin(p16);
AnalogIn td_pin(p17);

AnalogIn pv_amp(p19);
AnalogOut Aout(p18);

DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
Timer t;

LocalFileSystem local("local");

float amp = 1.5; // Desired voltage at the variable attenuator corresponding to -10 dB 
float amp_detector = 1.686; // Desired voltage at the output of the detector with VA set at -10 dB and input power = 5 dBm
float input_scaling_factor = amp/amp_detector;
float scaled_input;

float Kp = kp_pin.read()*10;     // values from 0.0 to 10.0
float Ti = ti_pin.read()*1000;      // values from 0.0 to 1000.0
float Td = td_pin.read();    // values from 0.0 to 1.0

PID controller_amp(Kp, Ti, Td, RATE);


int main() {

  //Analog input from 0.0 to 3.3 V
  controller_amp.setInputLimits(0.0, 3.3);
  
  //Pwm output from 0.0 to 3.3 V
  controller_amp.setOutputLimits(0.0, 1.0);
  
  //If there's a bias.
  controller_amp.setBias(0.0);
  controller_amp.setMode(0);
  
  controller_amp.setSetPoint(0.0);
  led_1 = 1;
  t.start();

 FILE *fp = fopen("/local/PID.txt", "w");  // Open "out.txt" on the local file system for writing

 // while(t.read() <= 5.0){
  while (1){
    
    controller_amp.setSetPoint(amp);
    led_2 = 1;
   
    //Update the process variable.
    scaled_input = pv_amp.read() * input_scaling_factor;
    controller_amp.setProcessValue(scaled_input);
    
    //Set the new output.
    Aout = controller_amp.compute();

 //   fprintf(fp, "%f\t%f\t%f\n", Kp, Ti, Td);

    //Wait for another loop calculation.
    wait(RATE);
  }
 // fclose(fp);
//  led_1 = 0; 
 // led_2 = 0;

}