/*
#include "PID.h"
#include "mbed.h"
#include "time.h"
#define RATE 0.0001

//Kc, Ti, Td, interval
//PID controller_amp(2.0, 100.0, 0.5, RATE);
//PID controller_amp(1.65, 10000.0, 0.0, RATE);
PID controller_amp(1.65, 10000.0, 0.0, RATE);


AnalogIn pv_amp(p16);     //output from the amp detector
PwmOut co_amp(p26);       //output from PID to adjust amplitude
//AnalogOut co_amp(p18);
DigitalOut myled(LED2);

LocalFileSystem local("local");


float amp = 1.5; // Desired voltage at the variable attenuator corresponding to -10 dB 
float amp_detector = 1.686; // Desired voltage at the output of the detector with VA set at -10 dB and input power = 5 dBm
float input_scaling_factor = amp/amp_detector;
float scaling_factor;
float output;

int main(){

  //Analog input from 0.0 to 3.3 V
  controller_amp.setInputLimits(0.0, 3.3);
  
  //Pwm output from 0.0 to 3.3 V
  controller_amp.setOutputLimits(0.0, 1.0);
  
  //If there's a bias.
  controller_amp.setBias(0.0);
  controller_amp.setMode(0);
  
  //We want the process variables to be V_amp
  controller_amp.setSetPoint(0.0);
  myled = 1;
  
  wait(3);
  controller_amp.setSetPoint(amp);
  myled = 0;

  FILE *fp = fopen("/local/data.txt", "w");


  while(1){
    //Update the process variable.
    scaling_factor = pv_amp.read() * input_scaling_factor;
  //scaling_factor = pv_amp.read() * 1.5/1.686;
    controller_amp.setProcessValue(scaling_factor);
    
    //Set the new output.
    co_amp = controller_amp.compute();
   // co_amp.write(controller_amp.compute());
    
    

    fprintf(fp, "Input Voltage %f\n", pv_amp.read());
  //  fprintf(fp, "Output Voltage %f\n",co_amp.write(controller_amp.compute()) );
    fprintf(fp, "Scaling Factor %f\n", scaling_factor);
  //  fprintf(fp, "Process Variable" "%f\n",controller_amp.setProcessValue(scaling_factor));
    fclose(fp);
    
    
    //Wait for another loop calculation.
    wait(RATE);
  }

}
*/