/*

#include "PID.h"
#include "mbed.h"
#include "time.h"
#define RATE 0.0001

PID controller_amp(1.45, 10000.0, 0.0, RATE);

LocalFileSystem local("local");               // Create the local filesystem under the name "local"
AnalogIn in(p16);
//PwmOut out(p26);
AnalogOut out(p18);

DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
Timer t;

float amp = 1.5; // Desired voltage at the variable attenuator corresponding to -10 dB 
float amp_detector = 1.686; // Desired voltage at the output of the detector with VA set at -10 dB and input power = 5 dBm
float input_scaling_factor = amp/amp_detector;
float scaling_factor;
     

int main() {

  //Analog input from 0.0 to 3.3 V
  controller_amp.setInputLimits(0.0, 3.3);
  
  //Pwm output from 0.0 to 3.3 V
  controller_amp.setOutputLimits(0.0, 1.0);
  
  //If there's a bias.
  controller_amp.setBias(0.0);
  controller_amp.setMode(0);
  
  controller_amp.setSetPoint(0.0);
  t.start();
  
  FILE *fp = fopen("/local/rise_PID.txt", "w");  // Open "out.txt" on the local file system for writing

    while(t.read() <= 2.0){
        fprintf(fp, "%f\t%f\t%f\n", t.read(), in.read()*3.3, out.read()*3.3);
        led_1 = 1;
        if (t.read() >= 1.0){
            led_2 = 1;
            controller_amp.setSetPoint(amp);
            scaling_factor = in.read() * input_scaling_factor;
            controller_amp.setProcessValue(scaling_factor);
            out = controller_amp.compute();
            }
            wait(RATE);
    }
    fclose(fp);
    led_1 = 0;
    led_2 = 0;
}
    */
    

