#include "mbed.h"
#include "GPS.h"
#include "Servo.h"
#include "PinDetect.h"
#include "nRF24L01P.h"

nRF24L01P myTransceiver(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

Serial pc(USBTX, USBRX);
GPS gps(p13, p14);
PinDetect pb1(p19);
PinDetect pb2(p20);
Servo servo(p21);

Serial esp(p28, p27); // tx, rx
DigitalOut reset(p26);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Timer t;

bool drunk = true;

int  count,ended,timeout,killSwitch = 0,Sig = 0;
char buf[2024];
char snd[1024];
 
char ssid[32] = "AndroidAP";     // enter WiFi router ssid inside the quotes
char pwd [32] = "ece4180a"; // enter WiFi router password inside the quotes

void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(),ESPServerSetup();

void signal(void){
    Sig = 1;
}

void kill_switch(void){
    if (killSwitch == 0){
        killSwitch = 1;
    }
}

int main() {
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    
    reset=0; //hardware reset for 8266
    pc.baud(9600);
    wait(0.5);
    reset=1;
    
    esp.baud(9600);
    
    pb1.attach_deasserted(&kill_switch);
    pb1.setSampleFrequency();
    
    pb2.attach_deasserted(&signal);
    pb2.setSampleFrequency();
    
    led1 = 0;
    led2 = 0;
    servo = 0;
    while (1){
        if (killSwitch == 1){
            led2 = 1;
            led1 = 1;
            servo = 1.0;
            ESPconfig();
            killSwitch = 2;
            led1 = 0;
        }
        if (Sig){
            if(drunk){
                servo = 1.0;
                led3 = 1;
                //wait(120);
                if (drunk)
                    ESPServerSetup();
            }
            else{
                servo = 0;
                led2 = 0;
            }
            killSwitch = 0;
            Sig = 0;
        }
        sleep();
    }
}

void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}

void ESPconfig()
{
    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"node.restart()\r\n");
    SendCMD();
    timeout=5;
    getreply();
    
    wait(2);
 
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "wifi.sta.config(\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\")\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);
 
    wait(5);
 
    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "print(wifi.sta.getip())\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
 
    wait(1);       
}

void ESPServerSetup(){
    while (!gps.sample()){
        wait(0.1);
    }
    pc.printf("\n---------- Setting up http server ----------\r\n");
        strcpy(snd, "srv=net.createServer(net.TCP)\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "srv:listen(80,function(conn)\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "conn:on(\"receive\",function(conn,payload)\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "print(payload)\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "conn:send(\"<!DOCTYPE html>\")\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "conn:send(\"<html>\")\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "conn:send(\"<h1> Come Pick Me up, I'm Drunk</h1>\")\r\n");
        SendCMD();
        wait(0.2);
        gps.sample();
        int n = sprintf(snd, "conn:send(\"<h2>I'm at Longitude: %f degrees %c, Latitude %f degrees %c</h2>\")\r\n", gps.longitude, gps.ew, gps.latitude, gps.ns);
        SendCMD();
        wait(0.2);
        strcpy(snd, "conn:send(\"</html>\")\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "end)\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "conn:on(\"sent\",function(conn) conn:close() end)\r\n");
        SendCMD();
        wait(0.2);
        strcpy(snd, "end)\r\n");
        SendCMD();
        wait(0.2);
        timeout=5;
        getreply();
        pc.printf(buf);
        pc.printf("\r\nDONE");
}

void SendCMD()
{
    esp.printf("%s", snd);
}
 
void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}