#include "mbed.h"
#include "mcp3208.h"

//Packet Strategy One for UDP
//Send out data at 1ms as normal
//after specified numReads send out data with
//terminated character
//On UDP/ESP8266 side read until you see the termination character

int readCounter = 1; 
int numReads = 45; //This value is numDataSetsInPacket in matlab and arduino code
int counterNum = 0;

MCP3208 input1(dp2, dp1, dp6, dp9);

Serial pc(dp16,dp15);

Ticker datalog; //Create the timer object

char datastr0[5];
char datastr1[5];
char datastr2[5];
char datastr3[5];
char datastr4[5];
char datastr5[5];


// Credit: Erik Olieman
void intToString(char *buffer, int value)
{
    int temp;
    temp = value / 1000;
    buffer[0] = temp + '0';
    value = value - temp * 1000;

    temp = value / 100;
    buffer[1] = temp + '0';
    value = value - temp * 100;

    temp = value / 10;
    buffer[2] = temp + '0';
    value = value - temp * 10;

    temp = value / 1;
    buffer[3] = temp + '0';
    value = value - temp * 1;

    buffer[4] = '\0';
}

bool tickerActivated = false;

void log_data(){
    tickerActivated = true;
}

int main(){
    pc.baud(921600); //Set baud rate
    pc.printf("Working!!\n\r");

    datalog.attach_us(&log_data,1000); // 1000us = 1ms

    while(1) {
        intToString(datastr0,input1.binary(0));
        intToString(datastr1,input1.binary(1));
        intToString(datastr2,input1.binary(2));
        intToString(datastr3,input1.binary(3));
        intToString(datastr4,input1.binary(4));
        intToString(datastr5,input1.binary(5));
        
        if(tickerActivated == true) { //This is true every 1ms
            tickerActivated = false;
            if(readCounter == numReads){
                readCounter = 1;
                counterNum = counterNum + 1;
                if(counterNum >= 9999) counterNum = 0;
                pc.printf("%s,%s,%s,%s,%s,%s\n\r",datastr0,datastr1,datastr2,datastr3,datastr4,datastr5);
            }
            else{
                readCounter++;
                counterNum = counterNum + 1;
                if(counterNum >= 9999) counterNum = 0;
                
                pc.printf("%s,%s,%s,%s,%s,%s,",datastr0,datastr1,datastr2,datastr3,datastr4,datastr5);  
            }
        }
    }
}
