//
//
//
#include "mcp3208.h"


MCP3208::MCP3208(PinName mosi, PinName miso, PinName clk, PinName cs)
:   _spi(mosi,miso,clk),
    _cs(cs),
    _vref(5.0)
{
    _spi.frequency(2000000);
    _spi.format(12,3);
    _cs = 1;
}

int
MCP3208::binary(int ch)
{
    _cs = 0;
    int ret = _spi.write((0x18|ch)<<2);
    int adb = _spi.write(0);
    _cs = 1;
    return adb;
}

float
MCP3208::volt(int ch)
{
    return _vref * binary(ch) / 4095;
}
