//HTTP_SERVER.h
#ifndef HTTP_SERVER_H
#define HTTP_SERVER_H

#include "EthernetInterface.h"
#include "definitions.h"
#include "string.h"

#define MAX_BUFFER_SIZE 1024

using namespace std;

enum PortNum {
    TCP_PORT = 80
};
/** HttpServer class
 *
 * This is the class to make a mbed a simple HTTP Server.
 */
class HttpServer
{
public:
    HttpServer();
    ~HttpServer();
    /** HTTP SERVER Initialization.
     *
     *  This function should be called first of all.
     *  @return result of init() as boolean.
     *  @retval TRUE SACCESS
     *  @retval FALSE
     */
    bool init();
    /** Run the surver service while listening flag is true.
     *
     *  @return state ending.
     *  @retval TRUE at error end.
     *  @retval FALSE at normal end.
     */
    bool run(channel *CH);

    //  Handlers
    TCPSocketServer     tcpsvr; //  TCP server
    TCPSocketConnection tcpcon; //  TCP server connection clerk
};

#endif