/*********************************************************************
*
* Driver Heaters DCM 8 channel - v4 (improvements)
*
* definitions.h
* 
* Mauricio Martins Donatti
* mauricio.donatti@lnls.br
*
* Electronic Support Group - GAE
* Brazilian Synchrotron Light Laboratory (LNLS)
* Brazilian Center for Research in Energy and Materials (CNPEM)
*
* Jan 2021
*
*
*
*******************************************************************/
#ifndef DEFINITIONS_H
#define DEFINITIONS_H

//Limit and digital filtering constants
#define CURR_MAX_LIMIT      2.5     //Maximum current limit allowed
#define DEFAULT_CURR_LIMIT  1.5     //Default current limit. If the config file does not exist, it will be created with this value 
#define ERROR_REP           10      //number of consecutive errors (no load or overcurrent) to trigger failure output

//Time constants
#define SAVE_CFG_DELAY_MIN  4000    //Delay to save new config in ms
#define DISPLAY_DELAY       2       //Delay to change channel display in seconds
#define DISPLAY_ADJ_DELAY   0.6     //Delay to blink display in adjust mode in seconds
#define HEARTBEAT_DELAY     0.7     //HeatBeat Delay in seconds
#define CONV_DELAY          0.01    //Convertion time in seconds. Define the sampling rate. One convertion with calculation takes about 500us    

//buffer lengths constants
#define HTML_MAX_SIZE       4500 

//Calibration constants
#define I_OFF   1.0                 //Current measurement offset in volts - linear coefficient
#define I_K     1.9839              //Current measurement constant of proportionality (in V/A) - angular coefficent

#ifdef SUPPLY_24V                   //adjusterments for 24V supply (adjusted to 26V input)
    #define V_K     0.2             //Voltage measurement constant of proportionality (in V/V) - angular coefficent (zeo offset)
    #ifndef CAL
        #define VC_OFF  99.915          //Control measurement offset in volts - linear coefficient
        #define VC_K    -23.675         //Control measurement constant of proportionality (in V/V) - angular coefficent 
    #else
        #define VC_OFF  0               //Control measurement offset in volts - linear coefficient
        #define VC_K    100             //Control measurement constant of proportionality (in V/V) - angular coefficent
    #endif
#else
    #define V_K     0.333           //Voltage measurement constant of proportionality (in V/V) - angular coefficent (zeo offset)
    #ifndef CAL
        #define VC_OFF  101.82          //Control measurement offset in volts - linear coefficient
        #define VC_K    -22.036         //Control measurement constant of proportionality (in V/V) - angular coefficent  
    #else
        #define VC_OFF  0               //Control measurement offset in volts - linear coefficient
        #define VC_K    100             //Control measurement constant of proportionality (in V/V) - angular coefficent
    #endif
    
#endif

//Digital Filter Constants
#define FILTC   0.85                  //IIR filter constant 1
#define FILTC2  0.15                  //IIR filter constant 2

//MBED LPC1768 pins attribution
//LCD Module Pins                  
#define LCD_TX      p28            //Display Tx Pin
#define LCD_RX      p27            //Display Rx Pin

//Front Panel buttons
#define BT_UP       p23             //Button up input - Front Panel
#define BT_DOWN     p22             //Button down input - Front Panel
#define BT_ENTER    p21             //Button enter input - Front Panel

//SPI pins 
#define CS_U4       p14             //AMC7812B U4 Chip select 
#define CS_U5       p8              //AMC7812B U5 Chip select
#define MOSI        p5              //Master (LPC1768) output to slave (AMC7812B) input
#define MISO        p6              //Master (LPC1768) input from slave (AMC7812B) output    
#define SCLK        p7              //Serial Clock - Up to 25MHz (+125ºC) or 50MHz (+105ºC). 10MHz is fast enough in this project

//AMC7812B pins
#define RST         p9              //Reset pin (active low)
#define DAC_CLR     p11             //Analog output clear pin
#define CNVT_U5     p10             //U5 Trigger input
#define AL_U5       p12             //U5 Alarm output
#define DAV_U5      p13             //U5 Data Available output
#define CNVT_U4     p15             //U4 Trigger input
#define AL_U4       p16             //U4 Alarm output
#define DAV_U4      p17             //U4 Data Available output

//Error interface
#ifdef ERROR_INTERFACE
    #define ERROR_PRINTF(fmt, ...)      printf("ERROR: " fmt "\r\n", ##__VA_ARGS__)
#else
    #define ERROR_PRINTF(fmt, ...)      __NOP()
#endif

//Debug interface
#ifdef DEBUG_INTERFACE
    #define DEBUG_PRINTF(fmt, ...)      printf("DEBUG: " fmt "\r\n", ##__VA_ARGS__)

#else
    #define DEBUG_PRINTF(fmt,...)       __NOP()
#endif

struct channel{
    float voltage;          
    float current;
    float control;                    //Control in %            
    float limit;                    //Current Limit
    char enable;                    //Enable Bit 
    char failure;                   //Failure Bit
    char overload;                  //Overload (and short current) indicator
    char noload;                    //No load (open heater) counter - up to 255
};

#endif