//HTTP_SERVER.h
#ifndef HTTP_SERVER_H
#define HTTP_SERVER_H

#include "EthernetInterface.h"
#include "definitions.h"
#include "string.h"

//Debug interface
#ifdef HTTP_DEBUG
    #define HTTP_PRINTF(fmt, ...)      printf("HTTP: " fmt "\r\n", ##__VA_ARGS__)

#else
    #define HTTP_PRINTF(fmt,...)       __NOP()
#endif

#define MAX_BUFFER_SIZE 1024


using namespace std;

enum PortNum {
    TCP_PORT = 80
};
/** HttpServer class
 *
 * This is the class to make a mbed a simple HTTP Server.
 */
class HttpServer
{
public:
    HttpServer();
    ~HttpServer();
    /** HTTP SERVER Initialization.
     *
     *  This function should be called first of all.
     *  @return result of init() as boolean.
     *  @retval TRUE SACCESS
     *  @retval FALSE
     */
    bool init(char *html_pointer,int html_len);
    /** Run the surver service while listening flag is true.
     *
     *  @return state ending.
     *  @retval TRUE at error end.
     *  @retval FALSE at normal end.
     */
    bool run(channel *CH,char* name);

    //  Handlers
    TCPSocketServer     tcpsvr; //  TCP server
    TCPSocketConnection tcpcon; //  TCP server connection clerk
    
private:
    //HTML file - with Javascript
    char *index_html;
    int index_html_len; //index with html length
        
    char* httpmethod;
    char* filepath;
    char* http_ver;
    
    char buffer[MAX_BUFFER_SIZE];   //receive and transmit buffer
    char tmp_buffer[200];           //aux buffer
    int status_code;                //http status code
    char reason_phrase[30];         //http reason phrase
    
    int i;                 //index buffer
};

#endif