//#define HTTP_DEBUG

#include "HTTP_SERVER.h"

//table colors vector
const char *color[] = {"#C8FFC8\0","#FF0000\0"};

HttpServer::HttpServer()
{
    buffer[0] = '\0';   //constructor
}

HttpServer::~HttpServer()
{
}
bool HttpServer::init(char *html_pointer,int html_len)
{
    index_html = html_pointer;
    index_html_len = html_len;
    
    //  TCP Socket setup
    //  To open Server-side PORT
    if(tcpsvr.bind(TCP_PORT)< 0) {
        return false;
    } 
    tcpsvr.set_blocking(true,1500); //set blocking socket

    //  Server start listening Request from a web browser.
    
    if(tcpsvr.listen(5) < 0) {
        return false;
    }
    
    
    return true;
}

bool HttpServer::run(channel *CH,char* name)
{            
    if(tcpsvr.accept(tcpcon) < 0) {
        //printf("(HTTP_SERVER) failed to accept connection.\r\n");
        return -1;
    }
    //  When conected
    while(tcpcon.is_connected()) 
    {
        tcpcon.set_blocking(false,100);
        //
        //  Request Analysis
        //
        
        HTTP_PRINTF("DEBUG MODE");
        httpmethod    = NULL;
        filepath     = NULL;
        http_ver     = NULL;
        switch(tcpcon.receive(buffer, 1023)) {
            case 0:
                //HTTP_PRINTF("received buffer is empty.");
                status_code = 400;
                sprintf(reason_phrase,"No Request\0");
                break;  
            case -1:
                HTTP_PRINTF("failed to read data from client.");
                status_code = 500;
                sprintf(reason_phrase,"Internal Server Error\0");
                break;
            default:
                HTTP_PRINTF("Received Data: %d",strlen(buffer));
                HTTP_PRINTF("-->\r\n");
                HTTP_PRINTF("%.*s[End of Request]",strlen(buffer),buffer);
                //  get HTTP method, File path, HTTP version
                httpmethod = strtok(buffer," ");
                filepath = strtok(NULL, " ");
                http_ver = strtok(NULL, "\r\n");
                HTTP_PRINTF("httpmethod: %s", httpmethod);
                HTTP_PRINTF("file path:  %s", filepath);
                HTTP_PRINTF("http ver :  %s", http_ver);
                break;
        }
        
        if (httpmethod == NULL) {
            buffer[MAX_BUFFER_SIZE - 1] = '\0';
            sprintf(buffer,"%s %d %s\r\nConnection: Close\r\n\r\n\0", http_ver, status_code, reason_phrase);
            HTTP_PRINTF("echo back done.");
            break;
        }
        
        //  Response
        if (strcmp(httpmethod,"GET") == 0 ) //GET request - always index.html stoed in index_html
        {
            HTTP_PRINTF("GET request incomming.");
            
            if(strcmp(filepath,"/")==0){
                buffer[MAX_BUFFER_SIZE-1] = '\0';
                status_code = 200;
                sprintf(reason_phrase,"OK");
    
                sprintf(buffer,"%s %d %s\r\nConnection: Close\r\nContent-Type: text/html\r\nKeep-Alive: timeout=15\r\n\r\n", http_ver, status_code, reason_phrase);
                tcpcon.send_all(buffer,strlen(buffer));
                tcpcon.send_all((char*)index_html,index_html_len);
            }
            
            break;
        } 
        if (strcmp(httpmethod,"POST") == 0 ) //POST request - javascript request
        {
            if(strcmp(filepath,"/read_data")==0){
                HTTP_PRINTF("POST read_data request incomming.");                
                for(i=0;i<=7;i++)
                {
                    sprintf(tmp_buffer,"%4.2f %3.2f %.1f %3.2f %d %d %d %d \0",CH[i].voltage,CH[i].current,CH[i].control,CH[i].limit,\
                        CH[i].failure,CH[i].overload>ERROR_REP,\
                        CH[i].noload>ERROR_REP,CH[i].enable);
                    tcpcon.send_all(tmp_buffer,strlen(tmp_buffer));
    
                }
            }
            
            if(strcmp(filepath,"/device_name")==0)
            {
                HTTP_PRINTF("POST device_name request incomming.");
                sprintf(buffer,"%s",name);
                tcpcon.send_all(buffer,strlen(buffer));
            }
            
            break;
            

        }      
    }
    tcpcon.close(); //always close the connection
    return 0;
}