//Michael McDonald
//Farkle Main

#include <time.h>
#include <stdlib.h>
#include <stdio.h>

#include "farkleMath.h"
#include "diceMath.h"
#include "MMA8452.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "temperature.h"
#include "PinDetect.h"
#include "mbed.h"


using namespace std;
MMA8452 acc(p28, p27, 40000);
Speaker mySpeaker(p25);
PinDetect pb1(p23);
PinDetect pb2(p22);
PinDetect pb3(p21);

enum InputType {aIn,bIn,cIn,shakeIn,stay};
enum StateType {startState,bState, rollState,turnState};
InputType input = stay;
StateType state = startState;

//Button callbacks
void pb1_hit_callback (void) {
    input = aIn;
};

void pb2_hit_callback (void) {
    input = bIn;
};

void pb3_hit_callback (void) {
    input = cIn;
};

//Sets up the accelerometer for me
void accelerometer() {
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
}

//Inputs for the accelerometer, put into shakeIn
void accIn(){ 
    double x = 0.0l;
    double y = 0.0l;
    double z = 0.0l;
    acc.readXYZGravity(&x,&y,&z);
    if ((fabs(x)>1.5)||(fabs(y)>1.5)) {
        input = shakeIn;
    }
};

int main() {
    
    extern Dice dice;   //make class objects
    extern FarkleMath farklemath; //make this class object as well
    extern TMP36 myTMP36;
    
    accelerometer();   //call accelerometer
    
    int seedAssist;   //helps make random numbers
    seedAssist = static_cast <int> (10000 * myTMP36.read()) % 12344; //helps make random numbers
    srand(time(0)+seedAssist);  //helps make random numbers
    
    //This code creats the  pushbuttons
    pb1.mode(PullUp);//a input pushbotton
    pb2.mode(PullUp);//b input pushbotton
    pb3.mode(PullUp);//c input pushbotton
    wait(.01);
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    
    bool counter = true;
    while(1) {
        switch(state) {
            case(startState):
            if (counter == true) {
                dice.displayStartScreen(dice.getNumOfDice());
                counter = false;
                }
                
            accIn();
            
            if (input == bIn) {
                state = bState;
                }
            else if (input == shakeIn) {
                dice.startDiceRoll();
                state = rollState;
                }
            else {
                state = startState;
                }
            break;
            
            case(bState):
            counter = true;
            dice.setNumOfDice();
            input = stay;
            state = startState;
            break;
            
            case(rollState):
            counter = true;
            if ((input == cIn)&&(farklemath.getTurnScore()!= 0)&&(dice.getTakeaway()!= 6)) {
                input = stay;
                dice.setNumberOfDice(6-dice.getTakeaway());
                state = startState;
                }
            else if (input == aIn) {
                farklemath.printEndGame(farklemath.getTurnScore());
                input = stay;
                state = turnState;
                }
            else {
                state = rollState;
                }
            break;
            
            case (turnState):
            counter = true;
            if (input == aIn) {
                farklemath.setRollScore(0);
                farklemath.setTurnScore(0);
                dice.setSetTakeaway(0);
                dice.setNumberOfDice(6);
                state = startState;
                }
            else {
                state = turnState;
                }
            break;  
        }
    }
}; //end of main
