//Function prototypes for calculating the different score values of the game
#ifndef FARKLEMATH_H
#define FARKLEMATH_H

class FarkleMath{
    public:
        FarkleMath(); //Constructor
        
        //Function prototypes for all possible scoring Dice
        void five(bool& value);
        void one(bool& value);
        void twofive(bool& value);
        void twoone(bool& value);
        void threeOne(bool& value);
        void threeTwo(bool& value);
        void threeThree(bool& value);
        void threeFour(bool& value);
        void threeFive(bool& value);
        void threeSix(bool& value);
        void flush(bool& value);
        void threePairs(bool& value);
        void twoTriplets(bool& value);
        void fourOfAKind(bool& value);
        void fiveOfAKind(bool& value);
        void sixOfAKind(bool& value);
        void isZero(bool& value);
        
        //Printing Score, Farkle, or "End Game"
        void printRollScore(bool& value);
        void printTurnScore(bool& value);
        void printFarkle(bool& value);
        void printEndGame(int);   
        
        //Setters and Getters
        void setRollScore(int input);
        void setTurnScore(int input);
        int getRollScore();
        int getTurnScore();
        
        //Calculates the Score 
        void calculateScore();
        
    private:
        //Variables
        int turnScore;
        int rollScore;
        bool temp;
}; //end of class
#endif