//This file contains all the score calculations for the different type of dicerolls

#include <iostream>
#include <fstream>
#include <iomanip>
#include <cmath>
#include <cstdlib>
#include <time.h>
#include <string>
#include <stdlib.h>
#include <stdio.h>
#include <sstream>

#include "farkleMath.h"
#include "diceMath.h"
#include "MMA8452.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "temperature.h"
#include "PinDetect.h"
#include "mbed.h"

using namespace std;
extern MMA8452 acc;
extern uLCD_4DGL uLCD;
extern PinDetect pb1;
extern PinDetect pb2;
extern PinDetect pb3;
extern Serial pc;
extern Speaker mySpeaker;
extern Dice dice;
FarkleMath farklemath;

//Calls in my setters and getters so I can use them
void FarkleMath::setRollScore(int input) {
    rollScore = input;
}
    
void FarkleMath::setTurnScore(int input) {
    turnScore = input;
}
    
int FarkleMath::getRollScore() {
    return rollScore;
}
    
int FarkleMath::getTurnScore() {
    return turnScore;
}

FarkleMath::FarkleMath() {
    turnScore = 0;
    rollScore = 0;
}


//The following code is the calculations for all possible ways 
//to get points in this game

void FarkleMath::five(bool& value) {
    if ((dice.getGetDiceResults(5)==(1||2))){
        value = false;
        rollScore += (50);
        dice.setSetDiceResult(5, 0);
        dice.setTakeaway((1));
        uLCD.locate(0,13);
        }
}

void FarkleMath::one(bool& value) {
    if ((dice.getGetDiceResults(1)==(1||2))){
        value = false;
        rollScore += (100);
        dice.setTakeaway((1));
        dice.setSetDiceResult(1, 0);
        uLCD.locate(0,13);
        }
}

void FarkleMath::twofive(bool& value) {
    if ((dice.getGetDiceResults(5)== 2)){
        value = false;
        rollScore += (100);
        dice.setSetDiceResult(5, 0);
        dice.setTakeaway((2));
        uLCD.locate(0,13);
        }
}

void FarkleMath::twoone(bool& value) {
    if ((dice.getGetDiceResults(1)==2)){
        value = false;
        rollScore += (200);
        dice.setTakeaway((2));
        dice.setSetDiceResult(1, 0);
        uLCD.locate(0,13);
        }
}

void FarkleMath::threeOne(bool& value) {
    if ((dice.getGetDiceResults(1)==3)){
        value = false;
        rollScore += 1000;
        dice.setSetDiceResult(1, 0);
        dice.setTakeaway(3);
        uLCD.locate(0,13);
        }
}

void FarkleMath::threeTwo(bool& value) {
    if ((dice.getGetDiceResults(2)==3)){
        value = false;
        rollScore += 200;
        dice.setSetDiceResult(2, 0);
        dice.setTakeaway(3);
        uLCD.locate(0,13);
        }
}
    
void FarkleMath::threeThree(bool& value) {
    if ((dice.getGetDiceResults(3)==3)){
        value = false;
        rollScore += 300;
        dice.setSetDiceResult(3, 0);
        dice.setTakeaway(3);
        uLCD.locate(0,13);
        }
}
    
void FarkleMath::threeFour(bool& value) {
    if ((dice.getGetDiceResults(4)==3)){
        value = false;
        rollScore += 400;
        dice.setSetDiceResult(4, 0);
        dice.setTakeaway(3);
        uLCD.locate(0,13);
        }
}
    
void FarkleMath::threeFive(bool& value) {
    if ((dice.getGetDiceResults(5)==3)){
        value = false;
        rollScore += 500;
        dice.setSetDiceResult(5, 0);
        dice.setTakeaway(3);
        uLCD.locate(0,13);
        }
}

void FarkleMath::threeSix(bool& value) {
    if ((dice.getGetDiceResults(6)==3)) {
        value = false;
        rollScore += 600;
        dice.setTakeaway(3);
        dice.setSetDiceResult(6, 0);
        uLCD.locate(0,13);
        }
}

void FarkleMath::flush(bool& value) {
    if ((dice.getGetDiceResults(1)==1)&&(dice.getGetDiceResults(2)==2)&&
        (dice.getGetDiceResults(3)==3)&&(dice.getGetDiceResults(4)==4)&&
        (dice.getGetDiceResults(5)==5)&&(dice.getGetDiceResults(6)==6)) {
        value = false;
        rollScore += 1500;
        dice.setTakeaway(6);
        for(int i = 1; i<=6; i++) {
        dice.setSetDiceResult(i, 0);
        uLCD.locate(0,13);
        }
    }
}
//why find easy ways to do stuff when you can just hard code it into the game!
void FarkleMath::threePairs(bool& value) {
    bool one = (dice.getGetDiceResults(1) == 2);
    bool two = (dice.getGetDiceResults(2) == 2);
    bool three = (dice.getGetDiceResults(3) == 2);
    bool four = (dice.getGetDiceResults(4) == 2);
    bool five = (dice.getGetDiceResults(5) == 2);
    bool six = (dice.getGetDiceResults(6) == 2); 
    //all possible combinations of the dice to get 
    bool oneTwoThree = ((one && two && three) == true);
    bool oneTwoFour = ((one && two && four) == true);
    bool oneTwoFive = ((one && two && five) == true);
    bool oneTwoSix = ((one && two && six) == true);
    bool oneThreeFour = ((one && three && four) == true);
    bool oneThreeFive = ((one && three && five) == true);
    bool oneThreeSix = ((one && three && six) == true);
    bool oneFourFive = ((one && four && five) == true);
    bool oneFourSix = ((one && four && six) == true);
    bool oneFiveSix = ((one && five && six) == true);
    bool twoThreeFour = ((two && three && four) == true);
    bool twoThreeFive = ((two && three && five) == true);
    bool twoThreeSix = ((two && three && six) == true);
    bool twoFourFive = ((two && four && five) == true);
    bool twoFourSix = ((two && four && six) == true);
    bool twoFiveSix = ((two && five && six) == true);
    bool threeFourFive = ((three && four && five) == true);
    bool threeFourSix = ((three && four && six) == true);
    bool threeFiveSix = ((three && five && six) == true);
    
    if ((oneTwoThree || oneTwoFour || oneTwoFive || oneTwoSix 
        || oneThreeFour || oneThreeFive || oneThreeSix || oneFourFive
        || oneFourSix || oneFiveSix || twoThreeFour || twoThreeFive
        || twoThreeSix || twoFourFive || twoFourSix || twoFiveSix 
        || threeFourFive || threeFourSix || threeFiveSix) == true){
        value = false;
        rollScore += 1500;
        dice.setTakeaway(6);
        uLCD.locate(0,13);
        for (int k = 1; k <=6; k++){
        dice.setSetDiceResult(k, 0);
        }
    }
}
void FarkleMath::twoTriplets(bool& value) {
    for (int i = 1; i <=6; i++){
        if ((dice.getGetDiceResults(i)==3)){
            for (int j = 1; j <=6; j++){
                if (((dice.getGetDiceResults(j)==3)&&(j != i))){
                    value = false;
                    rollScore += 2500;
                    dice.setTakeaway(6);
                        for (int k = 1; k <=6; k++){
                            dice.setSetDiceResult(k, 0);
                            uLCD.locate(0,13);
                            }
                    }
            }
        }
    }
}

void FarkleMath::fourOfAKind(bool& value) {
    for (int i = 1; i <=6; i++){
        if ((dice.getGetDiceResults(i)==4)) {
            value = false;
            rollScore += 1000;
            dice.setSetDiceResult(i, 0);
            dice.setTakeaway(4);
            uLCD.locate(0,13);
            }
        }
}
void FarkleMath::fiveOfAKind(bool& value) {
    for (int i = 1; i <=6; i++){
        if ((dice.getGetDiceResults(i)==5)) {
            value = false;
            rollScore += 2000;
            dice.setSetDiceResult(i, 0);
            dice.setTakeaway(5);
            uLCD.locate(0,13);
            }
        }
}
void FarkleMath::sixOfAKind(bool& value) {
    for (int i = 1; i <=6; i++) {
        if ((dice.getGetDiceResults(i)==6)) {
            value = false;
            rollScore += 3000;
            dice.setSetDiceResult(i, 0);
            dice.setTakeaway(6);
            uLCD.locate(0,13);
            }
    }
}

void FarkleMath::isZero(bool& value){
    if (value == true){
        rollScore = 0;
        }
}
    
void FarkleMath::printRollScore(bool& value){
    if (value == false){
        uLCD.locate(0,13);
        uLCD.text_width(1);
        uLCD.text_height(1);
        uLCD.printf("Roll Score: %d\n",rollScore);
        }
}
void FarkleMath::printTurnScore(bool& value){
    if (value == false){
        uLCD.locate(0,14);
        uLCD.text_width(1);
        uLCD.text_height(1);
        uLCD.printf("Turn Score: %d", turnScore);
        }
}
    
void FarkleMath::printFarkle(bool& value){
    if (value == true){
        rollScore = 0;
        turnScore = 0;
        uLCD.locate(0,12);
        uLCD.text_width(3);
        uLCD.text_height(3);
        uLCD.printf("FARKLE");
        }
}
//Prints the end game screen with amount of points for turn
void FarkleMath::printEndGame(int value) {
    uLCD.cls();
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("This\n");
    uLCD.printf("Turns\n");
    uLCD.printf("Score Is\n");
    uLCD.printf("--------\n");
    uLCD.printf("%d\n", value);
    uLCD.printf("Points!\n");
}
//Calculates the score for a turn. Set in a way from what gives the
//highest score to the lowest score. These are all function calls.
void FarkleMath::calculateScore(){
    temp = true;
    sixOfAKind(temp);
    fiveOfAKind(temp);
    fourOfAKind(temp);
    twoTriplets(temp);
    threePairs(temp);
    flush(temp);
    threeSix(temp);
    threeFive(temp);
    threeFour(temp);
    threeThree(temp);
    threeTwo(temp);
    threeOne(temp);
    twoone(temp);
    twofive(temp);
    one(temp);
    five(temp);
    isZero(temp);
    turnScore = turnScore + rollScore;
    printRollScore(temp);
    printTurnScore(temp);
    printFarkle(temp);
    rollScore = 0;
}
