//This file contains on the calculations to display the dice on the screen
#include <iostream>
#include <fstream>
#include <iomanip>
#include <cmath>
#include <cstdlib>
#include <time.h>
#include <string>
#include <stdlib.h>
#include <stdio.h>
#include <sstream>

#include "farkleMath.h"
#include "diceMath.h"
#include "MMA8452.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "temperature.h"
#include "PinDetect.h"
#include "mbed.h"

#define WHITE 0xFFFFFF
#define BLACK 0x000000
#define Red 0xFF0000
#define GREEN 0x00FF00
#define BLUE 0x0000FF
#define LGREY 0xBFBFBF
#define DGRAY 0x5F5F5F

using namespace std;

extern MMA8452 acc;
uLCD_4DGL uLCD(p9, p10, p11);
Serial pc(USBTX,USBRX);
extern Speaker mySpeaker;
Dice dice;
extern FarkleMath farklemath;


void Dice::setTakeaway(int input){
    takeaway = takeaway + input;
}
void Dice::setSetTakeaway(int input){
    takeaway =  input;
}

int Dice::getGetDiceResults(int input){
    return getDiceResult(diceResults, input);
}

void Dice::startDiceRoll(){
    rollDice(diceResults);
}

void Dice::rollDice(int array[]){
    mySpeaker.PlayNote(100.0,0.15,0.2);
    mySpeaker.PlayNote(200.0,0.15,0.2);
    mySpeaker.PlayNote(300.0,0.15,0.2);
    mySpeaker.PlayNote(400.0,0.15,0.2);
    mySpeaker.PlayNote(300.0,0.15,0.2);
    mySpeaker.PlayNote(200.0,0.15,0.2);
    mySpeaker.PlayNote(100.0,0.15,0.2);
    for(int i = 1; i<=6; i++){
        array[i] = 0;
}
    uLCD.cls();
    for (int counter = 1; counter <= numberOfDice; counter++){
        int throwValue = rollDie();
        array[throwValue] += 1;
        displayDiceOutline(counter);
        displayDiceNumber(counter, throwValue);
        }
    farklemath.calculateScore();
}

void Dice::setSetDiceResult (int position, int value){
    setDiceResult(diceResults,position,value);
    }


void Dice::setDiceResult (int array[], int position, int value){
    array[position] = value;
    }


int Dice::getDiceResult(int array[], int position){
    int space = array[position];
    return space;
    }

int Dice::rollDie(){
    int value = (rand()%6)+1;
    return value;
    }


Dice::Dice(){
    numberOfDice = 6;
    takeaway = 0;
}

void Dice::setNumberOfDice(int value){
    numberOfDice = value;
}

int Dice::getTakeaway(){
    return takeaway;
}

void Dice::displayStartScreen(int value){
    uLCD.cls();
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("Shake\n");
    uLCD.printf("Board To\n");
    uLCD.printf("--------\n");
    uLCD.printf("Roll\n");
    uLCD.printf("%d Dice\n", value);
}

int Dice::getNumOfDice(){
    return numberOfDice;
}

void Dice::setNumOfDice(){
    numberOfDice = (((numberOfDice % (6-takeaway))+1));
}

void Dice::displayDiceOutline(int currPos){
    //Draws the outline of dice in White
    if(currPos == 1){
    uLCD.filled_rectangle(0,0,41,41, WHITE);
}
    if(currPos == 2){
    uLCD.filled_rectangle(43,0,85,41, WHITE);
}
    if(currPos == 3){
    uLCD.filled_rectangle(87,0,126,41, WHITE);
}
    if(currPos == 4){
    uLCD.filled_rectangle(0,43,41,84, WHITE);
}
    if(currPos == 5){
    uLCD.filled_rectangle(43,43,85,84, WHITE);
}
    if(currPos == 6){
    uLCD.filled_rectangle(87,43,126,84, WHITE);
    }
}
void Dice::displayDiceNumber(int currPos, int currValue){
    int xpos = 0;
    int ypos = 0;
    int radius = 4;
    
    //This tells where each circle will be in order to display the dice
    if (currPos == 1){
        xpos = 0;
        ypos = 0;
    }
    if (currPos == 2){
        xpos = 43;
        ypos = 0;
    }
    if (currPos == 3){
        xpos =87;
        ypos = 0;
    }
    if (currPos == 4){
        xpos = 0;
        ypos = 43;
    }
    if (currPos == 5){
        xpos = 43;
        ypos = 43;
    }
    if (currPos == 6){
        xpos = 87;
        ypos = 43;
    }
    //This draws the circles to tell what dice it is in Black
    if (currValue == 1){
        uLCD.filled_circle(xpos + 20, ypos + 20, radius, BLACK);
    }
    if (currValue == 2){
        uLCD.filled_circle(xpos + 10, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 32, radius, BLACK);
    }
    if (currValue == 3){
        uLCD.filled_circle(xpos + 10, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 21, ypos + 21, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 32, radius, BLACK);
    }
    if (currValue == 4){
        uLCD.filled_circle(xpos + 10, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 10, ypos + 32, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 32, radius, BLACK);
    }
    if (currValue == 5){
        uLCD.filled_circle(xpos + 10, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 10, ypos + 32, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 32, radius, BLACK);
        uLCD.filled_circle(xpos + 21, ypos + 21, radius, BLACK);
    }
    if (currValue == 6){
        uLCD.filled_circle(xpos + 10, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 10, ypos + 32, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 10, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 32, radius, BLACK);
        uLCD.filled_circle(xpos + 10, ypos + 21, radius, BLACK);
        uLCD.filled_circle(xpos + 32, ypos + 21, radius, BLACK);
    }
}