#include "mbed.h"
#include "trostrukiSedamSeg.h"

Ticker DrsDebouncer;                // Timeri za debouncanje interrupta
Ticker UpozorenjaDebouncer;
Ticker Multiplexer;                 // Timer za multipleksiranje displaya
InterruptIn DrsButton(PB_10);       // Intterupt tipkala
InterruptIn UpozorenjaButton(PB_4);
AnalogIn Ain(PC_0);                 // Analogni ulaz za brzinu
PwmOut servo(PA_10);                // Pwm izlaz za ukljucivanje serva

char zaPrikazati[4];               

SedamSeg prikaz;    // Inicijalizacija klase SedamSeg

// Enum za koristenje u switch case-u
volatile enum state{
    BRZINA,
    DRS,
    UPOZORENJA   
} s;

// Pototipi funkcija
void drsInt();
void debouncedDrsInt();
void upozorenjaInt();
void debouncedUpozorenjaInt();
void displaySeg();

int main() {
    
    float ADCvalue;
    
    servo.period_ms(20);
    servo.pulsewidth_us(1250);

    DrsButton.mode(PullDown);
    DrsButton.rise(&drsInt);
    DrsButton.fall(&drsInt);
    
    UpozorenjaButton.mode(PullDown);
    UpozorenjaButton.rise(&upozorenjaInt);
    UpozorenjaButton.fall(&upozorenjaInt);
    
    Multiplexer.attach(&displaySeg,0.005);

    while(1){
        switch(s){
            case DRS:
                servo.pulsewidth_us(2000);
                sprintf(zaPrikazati,"%s","DRS");
                break;
            case UPOZORENJA:
                servo.pulsewidth_us(1250);
                sprintf(zaPrikazati,"%s","UPO");
                break;
            default:
                servo.pulsewidth_us(1250);
                // Skaliranje ulaza s 0 - 1 na 0 - 300kmh
                ADCvalue = Ain - 0.03;
                ADCvalue = (ADCvalue < 0) ? 0 : ADCvalue;
                ADCvalue *= 309.27;
                
                sprintf(zaPrikazati,"%i",(int)ADCvalue);
                if(ADCvalue < 10){
                    zaPrikazati[2] = zaPrikazati[0];
                    zaPrikazati[0] = '0';
                    zaPrikazati[1] = '0';
                }
                else if(ADCvalue < 100){
                    zaPrikazati[2] = zaPrikazati[1];
                    zaPrikazati[1] = zaPrikazati[0];
                    zaPrikazati[0] = '0';
                }
                break;
        }
        
        wait(0.1);
    }    
}

void drsInt(){
    DrsButton.disable_irq();
    DrsDebouncer.attach(&debouncedDrsInt,0.02);
}

void debouncedDrsInt(){
    DrsDebouncer.detach();
    s = (DrsButton && !UpozorenjaButton) ? DRS : (UpozorenjaButton ? UPOZORENJA : BRZINA);
    DrsButton.enable_irq();
}

void upozorenjaInt(){
    UpozorenjaButton.disable_irq();
    UpozorenjaDebouncer.attach(&debouncedUpozorenjaInt,0.02);
}

void debouncedUpozorenjaInt(){
    UpozorenjaDebouncer.detach();
    s = UpozorenjaButton ? UPOZORENJA : (DrsButton ? DRS : BRZINA);
    UpozorenjaButton.enable_irq();
}

void displaySeg(){   
    prikaz.displaySeg(zaPrikazati);
}