 // This program is borrowed from the MTS Multi-Hackers page and configured 
 // to work with the Freescale FRDM-K64F platform.
 
 #include "mbed.h"
 #include "MTSSerial.h"
 #include "Wifi.h"

DigitalOut gpo(D0);
DigitalOut led(LED_BLUE);

int main()
{
   std::string ssid = "CloudNet";
   std::string securityKey = "CloudNetPass";
   Wifi::SecurityType securityType = Wifi::WPA;
 
   //Wait for wifi module to boot up
   for (int i = 10; i >= 0; i = i - 2) {
       wait(2);
       printf("Waiting %d seconds...\n\r", i);
   }
 
   //Setup serial interface to WiFi module - FRDM-K64F
   MTSSerial* serial = new MTSSerial(PTC17, PTC16, 256, 256);
   serial->baud(9600);
 
   //Setup Wifi class
   Wifi* wifi = Wifi::getInstance();
   printf("Init: %s\n\r", wifi->init(serial) ? "SUCCESS" : "FAILURE");
 
   //Setup and check connection
   printf("Set Network: %s\n\r", getCodeNames(wifi->setNetwork(ssid, securityType, securityKey)).c_str());
   printf("Set DHCP: %s\n\r", getCodeNames(wifi->setDeviceIP("DHCP")).c_str());
   printf("Connect: %s\n\r", wifi->connect() ? "Success" : "Failure");
   printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
   printf("Ping Server: %s\n\r", wifi->ping("8.8.8.8") ? "Success" : "Failed");
 
   //Disconnect from network
   printf("Disconnecting...\n\r");
   wifi->disconnect();
   printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
 
   printf("End Program\n\r");    
    while (true) {
        gpo = !gpo; // toggle pin
        led = !led; // toggle led
        wait(0.2f);
    }
}