#include "mbed.h"

DigitalOut myled(LED1);

#define CURTO   0.3
#define LONGO   0.9

void pisca(float tempo)
{
    myled = 1;
    wait(tempo);
    myled = 0;
}

void piscaCurto()
{
    pisca(CURTO);
}

void piscaLongo()
{
    pisca(LONGO);
}

void pausa(float tempo)
{
    wait(tempo);
}

int main() {
    pausa(1);
    while(1) {
        printf("S\n");
        piscaCurto();
        pausa(CURTO);
        piscaCurto();
        pausa(CURTO);
        piscaCurto();

        pausa(1);

        printf("O\n");
        piscaLongo();
        pausa(CURTO);
        piscaLongo();
        pausa(CURTO);
        piscaLongo();

        pausa(1);

        printf("S\n");
        piscaCurto();
        pausa(CURTO);
        piscaCurto();
        pausa(CURTO);
        piscaCurto();

        wait(1);
    }
}

