#include "UpravljanjePWM.h"
#include "mbed.h"

bool smjer=false;
bool onOff=false;
void psmjera();
void on_off();
Timer debounce;

UpravljanjePWM::UpravljanjePWM(PinName pin1,PinName pin2, PinName pin3, PinName pin4, PinName pin5) : pwm1(pin1), pwm2(pin2), ain(pin3),int1(pin4), int2(pin5)
{
    pwm1.period(0.010);
    pwm2.period(0.010);
    debounce.start();
    int1.rise(&psmjera);
    int2.rise(&on_off);

};

void UpravljanjePWM::pwm(float treshold)
{
    if(ain<treshold||onOff==false) {
        pwm1=0;
        pwm2=0;
    } else {
        if(smjer==false) {
            pwm1=ain;
            pwm2=0;
        } else {
            pwm1=0;
            pwm2=ain;
        }
    }
}

bool UpravljanjePWM::zadanismjervrtnje()
{
    return smjer;
}

void psmjera()
{
    if(debounce.read_ms()>200) {
        smjer=!smjer;
        debounce.reset();
    }
};
void on_off()
{
    if(debounce.read_ms()>200) {
        onOff=!onOff;
        debounce.reset();
    }
};
