#include "mbed.h"
#include "BNO055.h"
#include "ExtendedTimer.h"
#include "SDFileSystem.h"

Serial pc(USBTX,USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

I2C i2c(p28,p27);
BNO055 imu(i2c, 0x28 << 1);//calls class of imu, moves bytes for address

InterruptIn pulseIn1(p21);
InterruptIn pulseIn2(p22);

ExtendedTimer t;
Ticker fileTime;
Ticker readTime;

SDFileSystem fs(p5, p6, p7, p8, "fs");

int coincCounts;
bool timeToRead;
bool timeToSave;
bool print;

void interrupt() {
    if (!pulseIn1 && !pulseIn2) {
        coincCounts++;
    }
}
void triggerCollection() {
    timeToRead = true;  // flag to collect data
    led3 = 1;
}
void triggerSave() {
    timeToSave = true;      // flag to save data
    led4 = 1;
}

int main() {
    coincCounts = 0;
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    bool mountFailure = fs.mount();
    if (mountFailure != 0) {
        pc.printf("Failed to mount the SD card.\r\n");
        led1 = 1;
        return -1;  // ends program with error status
    }
    FILE* fp = fopen("/fs/log.txt","a");
    if (fp == NULL) {
        pc.printf("Failed to open the file.\r\n");
        fs.unmount();
        led1 = 1;
        return -1;
    }
    fprintf(fp,"------------------\r\n");
    fprintf(fp,"Time\tFace\tRoll\tPitch\tCoincidence\r\n");
    fileTime.attach(&triggerSave,300);
    readTime.attach(&triggerCollection,59);
    if(imu.checkID() == 0xA0){//calling imu making sure compiler is communicating with it
        imu.setMode(BNO055_MODE_NDOF);
        imu.setAngleUnits(BNO055_ANGLE_UNITS_DEGREE);//allows programmer to change between using degrees or radians
    }
    pulseIn1.fall(&interrupt);
    pulseIn2.fall(&interrupt);
    led2 = 1;
    t.start();
    while(t <= 12000){
        if (timeToRead == true) {
            fprintf(fp, "%5.3f \t %.2f \t %.2f \t %.2f  \t %d \r\n", t.read()/60, imu.readHeading(), imu.readRoll(), imu.readPitch(), coincCounts); 
            pc.printf("Reading...\r\n");
            timeToRead = false;
            coincCounts = 0;
            led3 = 0;
        }
        if (timeToSave == true) {
            fclose(fp);
            fp = fopen("/fs/log.txt","a");
            pc.printf("Saved!\r\n");
            timeToSave = false;
            led4 = 0;
        }
    } 
    fclose(fp);     //close file
    fs.unmount();   //unmount SD
    pc.printf("Safe to remove SD");
}
