#ifndef _TERMINAL_HPP_
#define _TERMINAL_HPP_

#include <list>
#include <string>
#include "mbed.h"
#include "CmdFactory.h"
#include "dbg.h"


class Terminal
{
    public:
        Terminal(Settings* settings, Serial *serial, InterruptIn* pinStart);
        ~Terminal();
        
        void start(void);
        void executeCmd(string rxBuffer);
 
    private:
        void buttonPressed();

        static list<string> tokenize(const string& str, const string& delimiters = " ");

        Settings* settings_;
        Serial *serial_;
        InterruptIn* pinStart_;
        volatile bool buttonStart_;
        
        CmdFactory *cmdFactory_;

};

#endif
