#include <stdio.h>
#include <limits>
#include "Variable.h"

std::string to_string(const int32_t val)
{
    char buffer[10];
    sprintf(buffer,"%ld",val);
    return std::string(buffer);
}

Variable::ValueDescription Variable::none[] = {{0,0}};

int32_t Variable::nonSetValue()
{
    return std::numeric_limits<int32_t>::min();
}

Variable::Variable()
    : name_("")
    , description_("")
    , pValueDescriptions_(none)
    , value_(nonSetValue())
{
}

bool Variable::endGuard() const
{
    return value_ == nonSetValue();
}

Variable::Variable(const char* name, const char* description, int32_t value, const ValueDescription* const pValueDescriptions)
    : name_(name)
    , description_(description)
    , pValueDescriptions_(pValueDescriptions)
    , value_(value)
{
}

std::string Variable::name() const
{
    return name_;
}

std::string Variable::help() const
{
//    std::ostringstream temp;
    std::string temp(description_);
    temp.append("\r\n");

    for (const ValueDescription* p = pValueDescriptions_; !p->isEnd(); ++p)
    {
        if (p->isEndRange())
        {
            continue;
        }

        temp.append("    ");

        if ((p+1)->isEndRange())
        {
            temp.append(to_string(p->value));
            temp.append("...");
            temp.append(to_string((p+1)->value));
            temp.append(" ");
            temp.append(p->description);
        }
        else
        {
            temp.append(to_string(p->value));
            temp.append(": ");
            temp.append(p->description);
            temp.append(" ");
        }
        temp.append("\r\n");
    }
    return temp;
}

std::string Variable::describe(int32_t value) const
{
    for (const ValueDescription* p = pValueDescriptions_; !p->isEnd(); ++p)
    {
        if (p->value > value || p->isEndRange())
        {
            continue;
        }

        if ((p+1)->isEndRange())
        {
            if ((p->value <= value) && (value <= (p+1)->value))
            {
                std::string temp(to_string(value));
                temp.append(p->description);
                return temp;
            }
        } else
        if (p->value == value)
        {
            std::string temp(to_string(value));
            temp.append(" - ");
            temp.append(p->description);
            return temp;
        }
    }
    return "";
}

bool Variable::set(int32_t value)
{
    if (describe(value).size() == 0)
    {
        return false;
    }
    value_ = value;
    return true;
}

int32_t Variable::get() const
{
    return value_;
}

std::string Variable::describe() const
{
    return  describe(get());
}
