#include "TxCmd.h"


TxCmd::TxCmd(Settings* radioSettings)
    : RadioCmd(radioSettings)
    , settings_(radioSettings)
{
    queryable_ = true;
    delay = settings_->get("delay");
}

TxCmd::~TxCmd()
{
}

bool TxCmd::execute(list<std::string> args)
{
    debug( "Performing tx\r\n" );
    txBuffer = args.empty() ? string("TXTXTX") : *args.begin();
    return true;
}

Cmd::Status TxCmd::process()
{
    RadioContex* p = getRadioContex();
    p->Send(txBuffer);
    wait_ms(delay);
    return CONTINUE;
}

string TxCmd::cmd()
{
    return "tx";
}

string TxCmd::desc()
{
    return "transmit string - tx [string]";
}

string TxCmd::getResponse(void)
{
    return "tx cmd rulez!";
}

