#include <cstdlib>
#include "GetRegisterCmd.h"
#include "dbg.h"
#include "Settings.h"

GetRegisterCmd::GetRegisterCmd(Settings* settings)
    : RadioCmd(settings)
{
}

GetRegisterCmd::~GetRegisterCmd()
{
}

string GetRegisterCmd::cmd()
{
    return "gr";
}

string GetRegisterCmd::desc()
{
    return "prints all registers";
}

bool GetRegisterCmd::execute(list<string> args)
{
    const uint32_t perLine = 16;

    printf("     ");
    for (uint32_t i = 0; i < perLine; ++i)
    {
        printf(" %.2lx", i);
    }
    printf("\r\n");

    for (uint32_t i = REG_FIFO; i <= REG_BITRATEFRAC; ++i)
    {
        if ((i & (perLine-1)) == 0)
        {
            printf("\r\n %.2lx  ", i);
        }

        printf(" %.2x", getRadioContex()->radio().Read(i));
    }
    printf("\r\n");
    return true;
}

string GetRegisterCmd::getResponse(void)
{
    return "";
}

