#include "RxCmd.h"

RxCmd::RxCmd(Settings* radioSettings)
    : RadioCmd(radioSettings)
{
    queryable_ = true;
    p = getRadioContex();
}

RxCmd::~RxCmd()
{
}

bool RxCmd::execute(list<string> args)
{
    debug( "Performing rx\r\n" );
    p->initReceive();
    return true;

}

Cmd::Status RxCmd::process()
{
    if (p->pool_rx())
    {
        printf("received: %s, rssi: %d, snr %d\r\n", p->Buffer, p->radio_->rssi_current_packet, p->radio_->snr_value);
    }
    return CONTINUE;
}

string RxCmd::cmd()
{
    return "rx";
}

string RxCmd::desc()
{
    return "enables receive mode (looped)- rx";
}

string RxCmd::getResponse(void)
{
    return "rx cmd rulez!";
}

