/********************************************************
 *  Base abstract class for spectrum analysis
 *
 *  Mladen Adamovic, 3326/2016
 ********************************************************/

#include "AnalysisBase.hpp"

namespace etf
{
    AnalyzerBase::AnalyzerBase(int nData, int nFft, int nUse)
        : N_DATA_(nData), N_FFT_(nFft),
          fft_(nFft), wHm_(nData-1, nUse),
          xData_(nUse), wData_(nUse) {}

    void AnalyzerBase::Execute(const float xn[], float db[])
    {
        // Differencing
        for (int n=0; n<N_DATA_-1; n++)
            xData_[n] = xn[n+1] - 0.8f*xn[n];
            
        // Windowing
        wHm_.Execute(xData_, wData_);

        Analyze(wData_, db);
    }
}
