/********************************************************
 *  Class for spectrum analysis using FFT
 *
 *  Mladen Adamovic, 3326/2016
 ********************************************************/

#include "FFT_Analysis.hpp"

namespace etf
{
    FftAnalyzer::FftAnalyzer(int nData, int nFft)
        : AnalyzerBase(nData, nFft, nFft),
          yFft_(nFft/2+1) {}

    void FftAnalyzer::Analyze(const float xn[], float yn[])
    {
        fft_.Execute(xn, yFft_);    // Execute FFT
        
        // Translate to dB
        for (int n=0; n<=N_FFT_/2; n++)
            yn[n] = 10.0f*log10f(Norm(yFft_[n]));
    }
}
