/********************************************************
 *  Class for spectrum analysis using FFT (Header)
 *
 *  Mladen Adamovic, 3326/2016
 ********************************************************/

#ifndef FFT_ANALYZER_HPP
#define FFT_ANALYZER_HPP

#include "AnalysisBase.hpp"

namespace etf
{
    class FftAnalyzer : public AnalyzerBase
    {
    public:
        FftAnalyzer(int nData, int nFft);

    private:
        Array<Complex> yFft_;   // output of FFT

        virtual void Analyze(const float xn[], float yn[]);

        // disallow copy constructor and assignment operator
        FftAnalyzer(const FftAnalyzer& );
        FftAnalyzer& operator=(const FftAnalyzer& );
    };
}
#endif  // FFT_ANALYZER_HPP
