#include "sci_sensor.h"

sci_sensor::sci_sensor(PinName in1, PinName in2): _in1(in1), _in2(in2)
{
    // Variables used the convert the temperature to celcius.
    c1 = -1481.96;
    c2 = 2196200;
    c3 = 1.8636;
    c4 = 0.00000388;
    
    // Variables used to conver the photocell data to lux.
    la = -2;
    lb = 3.8062;
}

float sci_sensor::temp() // Function to return the temperature in celcius.
{
    float volt = _in1.read()*3.3; // Converting the reading to voltage.
    float T = c1+sqrt(c2 + (c3-volt)/c4); // Converting the voltage to celcius.
    return T; // Returns the temperature in celcius.

}

float sci_sensor::phc() // Function to return the illuminensce in lux.
{
    float volt = _in2.read()*3.3; // Converts raw data to voltage.
    float res = (3.3*3300/volt - 3300)/1000.00; // 3300 is the resistance of my resistor. This function converts voltage to resistance of the photocell.
    float lux = pow(10, la*log10(res)+lb); // Converts the resistance to lux.
    return lux;
}