#include "SCI_SENSOR.h"
 
LM19::LM19(PinName in1): _in1(in1)
{
    c1 = -1481.96;
    c2 = 2.1962*1000000.000;
    c3 = 1.8636;
    c4 = 3.88/1000000.000;
}
 
float LM19::temp()
{
    float volt=_in1.read()*3.3;
    float T=c1+sqrt(c2 + (c3-volt)/c4);
    return T;
}
 
PhotoCell::PhotoCell(PinName in1): _in1(in1)
{
    Rs = 10000.00;
}
 
float PhotoCell::light()
{
    float vlight=_in1.read()*3.3;
    //convert voltage into resistance
    //convert resistance into light
    float A =-2;
    float B = 3.8;
    float R = (3.3*Rs/vlight - Rs)/1000.00;
    float lux = pow(10, A*log10(R)+B);
    return lux;
}