#include "mbed.h"
#include "Flash_FileSystem.h"

FlashSPI flash(P0_9, P0_8, P0_7, P0_6, "flash");

int main()
{
    wait(0.1);
    printf("Hello World!\r\n");
    char buffer[100];
    FILE *fp;

    int i;
    
    printf("directory list\r\n");
    DIR *d = opendir("/flash");               // Opens the root directory of the local file system
    struct dirent *p;
    i = 0;
    while((p = readdir(d)) != NULL) {         // Print the names of the files in the local file system
        printf("%s\r\n", p->d_name);          // to stdout.
        i++;
    }
    closedir(d);
    printf("total %d files found.\r\n\n", i);
    
    fp = fopen("/flash/in1.txt", "a");
    printf("-0-\r\n");

    if(fp == NULL) {
        printf("Could not open file, assuming unformatted disk!\r\n");
        printf("Formatting disk!\r\n");
        flash.format();
        printf("Disk formatted!\r\n");
        printf("Reset your device!\r\n");
        while(1);
    } else {
        wait(0.2);
        fprintf(fp, "hello ");
        fclose(fp);
    }
    
    wait(0.5);
        
    fp = fopen("/flash/in2.txt", "a");
    if (fp == NULL) {
        printf("out.txt can't created.\r\n");
    } else {
        wait(0.2);
        fprintf(fp, "Hello 2 ");
        fclose(fp);
    }
    
    wait(0.5);
    
    fp = fopen("/flash/in1.txt", "r");
    if (fp == NULL) {
        printf("in1.txt can't open to read.\r\n");
    } else
    {
        fgets (buffer, 100, fp);
        printf("%s\r\n", buffer);
        fclose(fp);
    }

    wait(0.5);
       
    fp = fopen("/flash/in2.txt", "r");
    if (fp == NULL) {
        printf("in2.txt can't open to read.\r\n");
    } else
    {
        fgets (buffer, 100, fp);
        printf("%s\r\n", buffer);
        fclose(fp);
    }

}
