#ifndef S25FL216K_USB
#define S25FL216K_USB
 
#include "mbed.h"
#include "FATFileSystem.h"
#include "S25FL216K.h"

/** Local filesystem made with S25FL216K serial flash memory + FATFileSystem library
*/
class FlashSPI : public FATFileSystem {
public:
   
    FlashSPI(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* n);
    virtual int disk_initialize();
    virtual int disk_write(const uint8_t * data, uint64_t block);
    virtual int disk_read(uint8_t * data, uint64_t block);
    virtual int disk_status();
    virtual int disk_sync();
    virtual uint64_t disk_sectors();
    
protected:
    int _status;
    S25FL216K flash;
    
 
};

#endif
