/*
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
//#define _DEBUG_FS_HANDLER

#include "FSHandler.h"

#define CHUNK_SIZE 128

#define DEFAULT_PAGE "/index.htm"

//*FSHandler::FSHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket), m_err404(false)
FSHandler::FSHandler(const char* rootPath, const char* path, TCPSocketConnection* pTCPSocketConnection) : HTTPRequestHandler(rootPath, path, pTCPSocketConnection), m_err404(false)
{}

FSHandler::~FSHandler()
{
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler) destroy\r\n");
#endif
    if(m_fp) {
#ifdef _DEBUG_FS_HANDLER
        printf("++++(FSHandler) fclose start\r\n");
#endif
        fclose(m_fp);
#ifdef _DEBUG_FS_HANDLER
        printf("+++(FSHandler) fclose end\r\n");
#endif

    }
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler)Handler destroyed\r\n");
#endif
}

//static init
map<string,string> FSHandler::m_lFsPath = map<string,string>();

void FSHandler::mount(const string& fsPath, const string& rootPath)
{
    m_lFsPath[rootPath]=fsPath;
}


void FSHandler::doGet()
{
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler)doGet() - rootPath=%s, path=%s\r\n", rootPath().c_str(), path().c_str());
#endif
    //FIXME: Translate path to local/path
    string checkedRootPath = rootPath();
    if(checkedRootPath.empty())
        checkedRootPath="/";
    string filePath = m_lFsPath[checkedRootPath];
    if (path().size() > 1) {
        filePath += path();
    } else {
        filePath += DEFAULT_PAGE;
    }
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler)Trying to open %s\r\n", filePath.c_str());
#endif
    m_fp = fopen(filePath.c_str(), "r"); //FIXME: if null, error 404
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler) opened %s\r\n", filePath.c_str());
#endif

    if(!m_fp) {
#ifdef _DEBUG_FS_HANDLER
        printf("++++(FSHandler)404Error\r\n");
#endif

        m_err404 = true;
        setErrCode(404);
        const char* msg = "File not found.";
        setContentLen(strlen(msg));
//        respHeaders()["Content-Type"] = "text/html";
//        respHeaders()["Connection"] = "close";
        addRespHeaders("Content-Type", "text/html");
        addRespHeaders("Connection", "close");
        writeData(msg,strlen(msg)); //Only send header
        printf("++++(FSHandler)\r\nExit FSHandler::doGet() w Error 404\r\n");
        return;
    }
  //  printf("++++(FSHandler) Seek start\r\n");
    //Seek EOF to get length
    fseek(m_fp, 0, SEEK_END);
    setContentLen( ftell(m_fp) );
    fseek(m_fp, 0, SEEK_SET); //Goto SOF

//    respHeaders()["Connection"] = "close";
    addRespHeaders("Connection", "close");
 //   printf("++++(FSHandler)Write start\r\n");
    onWriteable();
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler)Exit doGet()\r\n");
#endif
}

void FSHandler::doPost()
{

}

void FSHandler::doHead()
{

}

void FSHandler::onReadable() //Data has been read
{

}

void FSHandler::onWriteable() //Data has been written & buf is free
{
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler)onWriteable() event\r\n");
#endif
    if(m_err404) {
#ifdef _DEBUG_FS_HANDLER
        printf("++++(FSHandler)m_err404\r\n");
#endif
        //Error has been served, now exit
        close();
        return;
    }
#ifdef _DEBUG_FS_HANDLER
    printf("++++(FSHandler)not m_err404\r\n");
#endif

    static char rBuf[CHUNK_SIZE];
    while(true) {
        int len = fread(rBuf, 1, CHUNK_SIZE, m_fp);
        if(len>0) {
            int writtenLen = writeData(rBuf, len);
            if(writtenLen < 0) { //Socket error
#ifdef _DEBUG_FS_HANDLER
                printf("++++(FSHandler) Socket error %d\r\n", writtenLen);
#endif
                /**  Not Work
                                if(writtenLen == TCPSOCKET_MEM) {
                                    #ifdef _DEBUG_FS_HANDLER
                printf("FSHandler: Socket error %d\n", writtenLen);
                #endif
                                    fseek(m_fp, -len, SEEK_CUR);
                                    return; //Wait for the queued TCP segments to be transmitted
                                } else {
                                    //This is a critical error
                                    **/
#ifdef _DEBUG_FS_HANDLER
                printf("++++(FSHandler)critical error\r\n");
#endif
                close();
                return;
                /**
                }
                **/
            } else if(writtenLen < len) { //Short write, socket's buffer is full
#ifdef _DEBUG_FS_HANDLER
                printf("++++(FSHandler)Short write, socket's buffer is full\r\n");
#endif
                fseek(m_fp, writtenLen - len, SEEK_CUR);
                return;
            }
        } else {
            close(); //Data written, we can close the connection
            return;
        }
    }
}

void FSHandler::onClose() //Connection is closing
{
    /**
    #ifdef _DEBUG_FS_HANDLER
        printf("FSHandler: onClose start \r\n");
    #endif
    if(m_fp){
    #ifdef _DEBUG_FS_HANDLER
        printf("FSHandler: fclose start \r\n");
    #endif
    fclose(m_fp);
    #ifdef _DEBUG_FS_HANDLER
    printf("FSHandler: fclose end \r\n");
    #endif
    }
    #ifdef _DEBUG_FS_HANDLER
        printf("FSHandler: onClose end \r\n");
    #endif
    **/
}


