#include "mbed.h"

SPI acc(p11, p12, p13); // MOSI, MISO, SCK
DigitalOut ss(p10); // slave select
InterruptIn taps(p15);
DigitalOut tapLED(LED1);
DigitalOut doubleTapLED(LED2);
Timeout tapIndic;
Timeout doubleTapIndic;
Timeout doubleTapThresholdEnd;
Timer singleWait;

void tapsRespond(void);
void tapsTimeout(void);
void doubleTapsTimeout(void);
void endDoubleThres(void);

int source;
volatile bool singleTapDet;
volatile bool doubleThreshold;

int main() {
    singleTapDet = false;
    doubleThreshold = false;
    singleWait.start();
    ss = 1;
    acc.format(8, 3); 
    acc.frequency(2000000);
    ss = 0;
    acc.write(0x31); // Address of data format register
    acc.write(0x0B); // format +/- 16g, 0.004 g/LSB
    ss=1;
    ss=0;
    acc.write(0x2D); // Address of power control register
    acc.write(0x08); // Put into MEASURE mode
    ss=1;
    ss=0;
    acc.write(0x1D); //Address code Tap Threshold register. 
    acc.write(0x50); //Sets Tap Threshold at 5 g. 
    ss=1;
    ss=0;
    acc.write(0x21); //Address Code for Tap Duration Register
    acc.write(0x10); //Sets tap duration to 10 ms. 
    ss=1;
    ss=0;
    acc.write(0x22); //Adress Code for Double tap gap register
    acc.write(0x05); //Sets double tap gap to 6.25 ms 
    ss=1;
    ss=0;
    acc.write(0x23); //Adress Code for Double tap window register
    acc.write(0xFF); //Sets double tap window to 318.75 ms. 
    ss=1;
    ss=0;
    acc.write(0x2A); //Adress Code for Double tap window register
    acc.write(0x07); //Sets axies for detection (Binary: 00000111)
    ss=1;
    ss=0;
    acc.write(0x2E); //Adress Code for Interrupt Enable register
    acc.write(0x60); //Sets Interrupt trigger at single and double taps (Binary: 01100000)
    ss=1;
    ss=0;
    acc.write(0x2F); //Adress Code for Interrupt Map register
    acc.write(0x60); //Sends double tap and single tap interrupts to INT2
    ss=1;
    taps.rise(&tapsRespond); //Reacts to a rise in the InterruptIn pin, running ISR tapsRespond
    while(true){ 
        if(singleTapDet && singleWait >= 0.05 && !doubleThreshold) {
            tapLED = 1;
            tapIndic.attach(&tapsTimeout, 1);
            singleTapDet = false;
            }
        if(singleTapDet && singleWait >= 0.2 && doubleThreshold) {
            singleTapDet = false;
            }
        }
    }
    
void tapsRespond(void) {
    ss=1;
    ss=0; 
    acc.write(0x80 | 0x30);
    source = acc.write(0x00);
    if(source & 0x40) {
        singleTapDet = true;
        singleWait.reset();
        }
    if(source & 0x20) {
        doubleTapLED = 1;
        doubleTapIndic.attach(&doubleTapsTimeout, 1);
        doubleThreshold = true;
        doubleTapThresholdEnd.attach(&endDoubleThres, 0.6);
        }
    ss=1;
}

void tapsTimeout(void) {
    tapLED = 0;
    }
    
void doubleTapsTimeout(void) {
    doubleTapLED = 0;
    }
    
void endDoubleThres(void) {
    doubleThreshold = false;
    }
