/*********************************************************
VIZIC TECHNOLOGIES. COPYRIGHT 2012.
THE DATASHEETS, SOFTWARE AND LIBRARIES ARE PROVIDED "AS IS." 
VIZIC EXPRESSLY DISCLAIM ANY WARRANTY OF ANY KIND, WHETHER 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
OR NONINFRINGEMENT. IN NO EVENT SHALL VIZIC BE LIABLE FOR 
ANY INCIDENTAL, SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, 
LOST PROFITS OR LOST DATA, HARM TO YOUR EQUIPMENT, COST OF 
PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, 
ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO 
ANY DEFENCE THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION,
OR OTHER SIMILAR COSTS.
*********************************************************/

/********************************************************
 IMPORTANT : This library is created for the mbed Microcontroller Software IDE
********************************************************/
 
 
#include "mbed.h"
#include "SMARTWAV.h"
        
// SMART WAV DEFAULT BAUD RATE: 9600bps
//It shoud be used like this : SMARTWAV audio(p13,p14,p15); for serial communication with SMARTWAV
SMARTWAV::SMARTWAV(PinName TXPin, PinName RXPin, PinName resetPin): _serialSMARTWAV(TXPin,RXPin), _resetPin(resetPin){    
    init();
}

/********** high level commands, for the user! */
void SMARTWAV::init(){         //configure the mbed for SMARTWAV board    
    _serialSMARTWAV.baud(9600);
    _resetPin=1;               //set the pin to 3.3v to avoid reset 
}
 
void SMARTWAV::reset(){        //Reset the SMARTWAV board
    _resetPin=0;               //set the pin to GND to reset 
    wait_ms(500);
    _resetPin=1;               //set the pin to 3.3v to end reset
    wait_ms(500);    
}

unsigned char SMARTWAV::sleep(){       //Send SMARTWAV to sleep mode / awake from sleep mode
  _serialSMARTWAV.putc('Z'); 
  return _serialSMARTWAV.getc();
}

unsigned char SMARTWAV::getStatus(){       //Check active status
  unsigned char status;
  
  _serialSMARTWAV.putc('A');
  status  = _serialSMARTWAV.getc();
  _serialSMARTWAV.getc();
  return status;
}

unsigned char SMARTWAV::playTracks(){       //Start playing any song on current Folder/Dir
  _serialSMARTWAV.putc('T'); 
  return _serialSMARTWAV.getc();
}

unsigned char SMARTWAV::pausePlay(){       //Pause / play song
  _serialSMARTWAV.putc('P'); 
  return _serialSMARTWAV.getc();
}

unsigned char SMARTWAV::rewindTrack(){       //Rewind Track
  _serialSMARTWAV.putc('R'); 
  return _serialSMARTWAV.getc();
}

unsigned char SMARTWAV::nextTrack(){       //Next Track
  _serialSMARTWAV.putc('N'); 
  return _serialSMARTWAV.getc();
}

unsigned char SMARTWAV::playTrackName(char name[]){        //play an Audio file contained on the micro SD card with the given name.
  unsigned char counter=0;
  
  //if (_serialSMARTWAV.writeable()) {
  _serialSMARTWAV.putc('F'); 
  //}
  while(1){
    //if (_serialSMARTWAV.writeable()) {
        _serialSMARTWAV.putc(name[counter]);
    //} else {
    //    break;
    //}
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  
  return _serialSMARTWAV.getc();
  //return 1;
}

unsigned char SMARTWAV::stopTrack(){       //Stop playing any active song
  
  //if (_serialSMARTWAV.writeable()) {
  _serialSMARTWAV.putc('S'); 
  //}
  return _serialSMARTWAV.getc();
  //return 1;
}

unsigned char SMARTWAV::continuousPlay(unsigned char enable){       //Enable/Disable continuous play, also disabled by calling stopTrack()
  unsigned char status;
  
  _serialSMARTWAV.putc('C');
  _serialSMARTWAV.putc(enable);
  status  = _serialSMARTWAV.getc();
  _serialSMARTWAV.getc();
  return status;
}

unsigned char SMARTWAV::volume(unsigned char vol){       //Set Volume 0-255
  _serialSMARTWAV.putc('V'); 
  _serialSMARTWAV.putc(vol); 
  //return _serialSMARTWAV.getc();
  return 1;
}

unsigned char SMARTWAV::setFolder(char name[]){        //Set/Enters inside a folder/path on the micro SD card with the given name.
  unsigned char counter=0;
  
  _serialSMARTWAV.putc('D'); 
  while(1){
    _serialSMARTWAV.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return _serialSMARTWAV.getc();
}

unsigned char SMARTWAV::getFileName(char name[]){ //Reads the name of the current/ last audio file being played on the SMARTWAV, and stores it on the name[] buffer.
  unsigned int i=0;
  
  _serialSMARTWAV.putc('I'); 
  _serialSMARTWAV.putc('S'); 
   //receive all the file name
    while(1){
        name[i]=_serialSMARTWAV.getc();
        if(name[i]==0x00){
            break;    
        }
        i++;
    }
  return _serialSMARTWAV.getc();  
}

unsigned char SMARTWAV::getFolderName(char name[]){ //Reads the name of the current folderDir/path name the SMARTWAV, and stores it on the name[] buffer.
  unsigned int i=0;
  
  _serialSMARTWAV.putc('I'); 
  _serialSMARTWAV.putc('D'); 
   //receive all the folder/path name
    while(1){
        name[i]=_serialSMARTWAV.getc();
        if(name[i]==0x00){
            break;    
        }
        i++;
    }
  return _serialSMARTWAV.getc();  
}

unsigned char SMARTWAV::getFileList(char list[]){ //Reads all the names of the .WAV files on the current folder/dir on the SMARTWAV, and stores it on the list[] buffer separated by comma ','.
  unsigned int i=0;
  
  _serialSMARTWAV.putc('I'); 
  _serialSMARTWAV.putc('L'); 
   //receive all the file names
    while(1){
        list[i]=_serialSMARTWAV.getc();
        if(list[i]==0x00){
            break;    
        }
        i++;
    }
  return _serialSMARTWAV.getc();  
}

unsigned char SMARTWAV::getFolderList(char list[]){ //Reads all the folders on the current folder/dir on the SMARTWAV, and stores it on the list[] buffer separated by comma ','.
  unsigned int i=0;
  
  _serialSMARTWAV.putc('I'); 
  _serialSMARTWAV.putc('X'); 
   //receive all the folder names
    while(1){
        list[i]=_serialSMARTWAV.getc();
        if(list[i]==0x00){
            break;    
        }
        i++;
    }
  return _serialSMARTWAV.getc();  
}

unsigned char SMARTWAV::playSpeed(unsigned char speed){   //Change current Play Speed: X0.5, X1, X1.5, X2, if track ends, play speed returns to 1.0X
  
  _serialSMARTWAV.putc('M');
  _serialSMARTWAV.putc(speed);
  _serialSMARTWAV.getc();
  return _serialSMARTWAV.getc();
}

