#include "mbed.h"
#include "MFRC522.h"
#include "TextLCD.h"
#include "EthernetInterface.h"
#include <string>
#include "MbedJSONValue.h"

#define MF_RESET    PTD0

DigitalOut          LedRed(LED2);
DigitalOut          LedGreen(LED1);
Serial              pc(USBTX, USBRX);
TextLCD             lcd(PTC3, PTC2, PTA2, PTB23, PTA1, PTB9, TextLCD::LCD20x4); // rs, e, d4-d7
MFRC522             RfChip(PTD2, PTD3, PTD1, PTE25, PTD0);           // mosi, miso, sclk, cs, reset
DigitalOut          ventil(PTB18);
InterruptIn         FLOW(PTE24);

int Count; 
//float Calc_mL, Calc_L;
float VOL;

void rpm()
{
    Count++;
}
void ScreenSTART()
{
    lcd.cls();
    lcd.printf("      HEINEKEN\n\n");
    lcd.printf(" Set your bracelet\n");
    lcd.printf(" against the reader");
}
void ScreenNATOCI(int left)
{
    lcd.cls();
    lcd.printf("Pour your beer!\n\n");
    lcd.printf("Left %d beers.",left);
}
void ScreenNEMA()
{
    lcd.cls();
    lcd.printf("\n   Sorry no more\n   beer for you.");
    wait(4);
    ScreenSTART();
}
void ScreenTNX()
{
    lcd.cls();
    lcd.printf("\n     Thank you\n  for consumption!");
    wait(4);
    ScreenSTART();
}
void ScreenWrongID()
{
    lcd.cls();
    lcd.printf("\n  You do not have\n    the correct\n     bracelet!");
    wait(4);
    ScreenSTART();
}

int main(void)
{
    LedRed = 0;
    LedGreen = 0;
    ventil = 1;
    Count = 0;

    lcd.printf("Starting...\n\n");
    pc.printf("\nStarting..\n");

    EthernetInterface eth;
    eth.init("10.10.0.2","255.255.255.0","10.10.0.1"); //Use DHCP
    eth.connect();
    //pc.printf("IP Address is %s\n\r", eth.getIPAddress());
    TCPSocketConnection sock;

    RfChip.PCD_Init();

    lcd.printf("Ready");
    //pc.printf("Ready");
    LedRed = 1; wait(.4);
    LedRed = 0; wait(.4);
    LedRed = 1; wait(.4);
    LedRed = 0; wait(.4);
    LedRed = 1; wait(.4);
    
    ScreenSTART();

    while(1) {
        VOL = 0;
        LedRed = 1;
        LedGreen = 0;
        Count = 0;

        if ( ! RfChip.PICC_IsNewCardPresent()) {
            wait_ms(500);
            continue;
        }
        if ( ! RfChip.PICC_ReadCardSerial()) {
            wait_ms(500);
            continue;
        }
        char cID[22];
        for (int i = 0; i < RfChip.uid.size; i++) {
            sprintf(cID+i*2, "%X02", RfChip.uid.uidByte[i]);
        }

        char http_cmd[1024];
        sprintf(http_cmd,"POST /rest/tap/%s HTTP/1.0\n\n",cID);
        //pc.printf("\n\r%s\n\r",http_cmd);

        sock.connect("10.10.0.1", 8080);
        sock.send_all(http_cmd, sizeof(http_cmd)-1);

        char buffer[300];
        int ret;
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
            //pc.printf("\n\r%s\n\r", buffer);

        }
        sock.close();

        string responseFULL(buffer);
        int start = responseFULL.find("{",0);
        int end = responseFULL.find("}",start);

        string response = responseFULL.substr(start, end-start+1);
        //pc.printf("%s",response);

        MbedJSONValue responseJSON;
        parse(responseJSON, response.c_str());

        int tap = responseJSON["tap"].get<int>();
        int left = responseJSON["left"].get<int>();

        pc.printf("tap?  %d \n\r",tap);
        pc.printf("left beer  %d \n\r",left);
        
        //pc.printf("%s \n\r",responseFULL);
        
        if(tap < 0) {
            ScreenWrongID();
        }    
        if(tap == 0) {
            ventil = 1;
            ScreenNEMA();
        }
        if(tap == 1) {
            ventil = 0;
            ScreenNATOCI(left);

            while(ventil==0) {
                LedGreen = 1;
                LedRed = 0;
                FLOW.rise(&rpm);              
                wait_ms(1500);                // za 0,5 - 2000
                FLOW.rise(NULL);              

                //Calc = (Count * 60) / 7.5;                //flow rate in L/hour
                //CalcMl = (Count * 8) / 3.6;               //flow rate in mL/hour        
                //pc.printf ("Flow L/hour: %d\r\n",Calc);  
                //pc.printf ("Flow mL/s: %.2f\r\n",CalcMl);  

                VOL += Count;
                //pc.printf("Sum = %.2f\n\r",sum);
                
                if(VOL>1600) {
                    ventil = 1;
                    ScreenTNX();             
                }
            }
        }
    }
}
     



