#include "mbed.h"
/*
    AUTHOR  Mariwan Jalal
   These projects try to make a communications channel between to NUCELO-L476RG
   using SPI protocol (Slave-Master). 
   You can send any kind of object and reproduced between the two module 
    USE IT AT YOUR OWN RESPONSIBILITY .. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND

*/

/*
    These projects should be used together
    SPI_NUCLEO_MASTER
    SPI_NUCLEO_SLAVE
*/

/*
Slave communication is shifted by one byte. To respond for ex for a START byte,
you need to put the ACK byte prepared on the bus even before having the START
byte received by the slave. As the Master write the SPI bus the START Command,
the prepared byte on the slave SPI bus will be transferred to the Master
immediately. So, you need to prepare the Slave device to shift the bytes by
one byte  as in the following example.
*/



Serial pc(USBTX,USBRX);



#define SPI_DUMMY     0X0000
#define SPI_CMD       0XADAD     //Anything as a CMD code.
#define SPI_FAULT     0xDD00       //Anything as a part of 16 bit as control byte

#ifdef _DEBUG
extern Serial pc;
#define DEBUG_MESSAGE(...) pc.printf(__VA_ARGS__)
#else
#define DEBUG_MESSAGE(...)
#endif

typedef unsigned char byte;

SPISlave slave(SPI_MOSI, SPI_MISO, SPI_SCK ,PA_4);
int res=0;
float d,c,e;

/*This will be the float number we wish to transfer. 
You can make a struct of multiple variable and send it in the same way*/

typedef union {
float sensor;
byte SPI_Packet[sizeof(float)];
}SPI_Packet_t;

SPI_Packet_t packet;
int main()
{
    pc.printf("Testing is started from slave side\n");
    slave.format(16,0);
    slave.frequency(1000000);
    unsigned short vs=0;
    slave.reply(SPI_DUMMY);   // Prime reply
    unsigned short tempVal=0;
    packet.sensor=1000.02;    //Value of the float number we wish to communicate
    while(1) {
        if(slave.receive()) {
            tempVal=(unsigned short) slave.read();        //Real command
            printf("----------------\n%x\n",tempVal);
            /*
                The switch is not necessary if you have only one command between
                 master-slave. This is useful if you wish to send different 
                 object depending on the command.
            */
            switch(tempVal){
            case SPI_CMD: {    /*Use this if you have different commands 
                                for sending different objects to the master.*/
                            tempVal=(sizeof(float))<<8| packet.SPI_Packet[0];
                            pc.printf("Packet=%x\n",tempVal);
                            slave.reply(tempVal);
                            for(unsigned int i=1; i<sizeof(float); i++){
                                while(!(slave.receive()))
                                    wait_ms(1);
                            vs=slave.read();        //Real command
                            if (vs==SPI_DUMMY){
                                //Continue sending bytes
                                {
                                  tempVal=0x00FF & packet.SPI_Packet[i];
                                  pc.printf("Packet=%x\n",tempVal);
                                  slave.reply(tempVal);
                                }
                            }
                            else {
                                slave.reply(SPI_FAULT); //ERROR CODE
                                break;
                            }
                        }
                    }

                    break;
            }

         }

    }
}
