#include <mbed.h>
/*
    AUTHOR  Mariwan Jalal
   These projects try to make a communications channel between to NUCELO-L476RG
   using SPI protocol (Slave-Master). 
   You can send any kind of object and reproduced between the two module 
    USE IT AT YOUR OWN RESPONSIBILITY .. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND

*/

/*
    These projects should be used together
    SPI_NUCLEO_MASTER
    SPI_NUCLEO_SLAVE
*/

SPI device(SPI_MOSI, SPI_MISO, SPI_SCK);


typedef unsigned char byte;

typedef union {
    float sensor;
    byte SPI_Packet[sizeof(float)];
}SPI_Packet_t;
unsigned short tem;
int i;
unsigned int paSize;
SPI_Packet_t spipacket;

DigitalOut cs(SPI_CS);


#define SPI_DUMMY     0X0000
#define SPI_CMD       0XADAD
#define SPI_FAULT     0xDD

Serial pc(SERIAL_TX, SERIAL_RX);

short sendToSlave(unsigned short value )
{
    short result=0;
    cs=1;
    wait_us(500);
    cs=0;
    device.write(value);
    wait_us(500);
    cs=1;
    wait_ms(40);
    cs=0;
    wait_us(500);
    result=device.write(0x0000);
    wait_us(500);
    cs=1;
    wait_ms(40);
    return result;
}

int main()
{
    device.format(16,0);
    device.frequency(1000000);
    tem=0;
    while(1) {
        
        tem=sendToSlave(SPI_CMD);       //RETURNED BYT IS DUMMY
        paSize=(tem & 0xFF00)>>8;
        if(paSize>0){
            spipacket.SPI_Packet[0]=(byte)(tem & 0x00FF);
            pc.printf("Packet=%x\n",spipacket.SPI_Packet[0]);
            pc.printf("packet size=%i\n",paSize);
            for (i=1; i<paSize; i++) {
                cs=1;
                wait_us(500);
                cs=0;
                tem=(unsigned short)device.write(SPI_DUMMY);
                wait_us(500);
                cs=1;
                wait_ms(40);
                if( ((tem & 0xFF00)>>8)!=SPI_FAULT){
                    spipacket.SPI_Packet[i]=(byte)(tem & 0x00FF);
                    pc.printf("Packet=%x\n",spipacket.SPI_Packet[i]);
                }
                    else {
                        pc.printf("wrong packet\n");
                        break;    //go out from for loop.
                          }
            }
        pc.printf("Temp= %04.2f\n",spipacket.sensor);
        pc.printf("------------------------------\n");
     }
    spipacket.sensor=0.0;// Reset the variable.
    wait(1);
    }
}
