#include "mbed.h"
/**
*   Writing and reading from Serial Flash memory
*   AT25512N-SH
*   http://ww1.microchip.com/downloads/en/DeviceDoc/AT25512-SPI-Serial-EEPROM-512-Kbits-20006218A.pdf
*   Author : Mariwan jalal
*/

SPI device(SPI_MOSI, SPI_MISO, SPI_SCK);

DigitalOut CS(SPI_CS);

Serial pc(USBTX, USBRX);
void read()
{
    CS=1;
    int v=0;
    for(int i=0x200; i<0x210; i++) {
        wait_ms(1);
        CS=0;
        device.write(0x03);
        device.write((i&0xff00)>>8);
        device.write(i&0xff);
        v=device.write(0);///dummy
        CS=1;
        pc.printf("Results for i=%i : %x\n",i,v);
    }

}
void write()
{
    for(int i=0x200; i<0x0210; i++) {
        CS=1;
        CS=0;
        wait_ms(1);
        device.write(0x01);
        device.write(0x00);
        CS=1;
        CS=0;
        device.write(0x6);
        CS=1;
        CS=0;
        device.write(0x02);
        device.write((i&0xff00)>>8);
        device.write(i&0xff);
        device.write((0xDA));
        CS=1;
        pc.printf("Address= %x %x\n",((i&0xff00)>>8), (i&0xff));
    }

}
int main()
{
    pc.printf("device Started\n");
    device.format(8, 0);
    device.frequency(1000000);
    pc.printf("START Write\n");
    write();
    pc.printf("START Read\n");
    read();
}